<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClient.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * HTTPクライアントクラス
 */
require_once dirname(__FILE__) . '/../../Http/SyL_HttpClient.php';
/**
 * XMLRPCクライアントリクエストクラス
 */
require_once 'SyL_XmlRpcClientRequest.php';
/**
 * XMLRPCクライアントレスポンスクラス
 */
require_once 'SyL_XmlRpcClientResponse.php';

/**
 * XMLRPCクライアントクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClient.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlRpcClient extends SyL_HttpClient
{
    /**
     * パラメータオブジェクトを取得する
     * 
     * @access protected
     * @param string XML RPCメソッド
     * @param string リクエストURL
     * @param string リクエストメソッド
     */
    function &createRequest($rpc_method, $url='/', $method='POST')
    {
        $parameter =& new SyL_XmlRpcClientRequest($url, $method);
        $parameter->setMethod($rpc_method);
        return $parameter;
    }

    /**
     * 結果オブジェクトを取得する
     * 
     * @access protected
     * @param string レスポンスデータ
     * @param string クライアントエンコード
     */
    function &createResponse(&$data, $client_encode='')
    {
        $response =& new SyL_XmlRpcClientResponse($data, $client_encode);
        return $response;
    }
}
