<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcServerReader.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLリーダクラス
 */
require_once dirname(__FILE__) . '/../SyL_XmlReader.php';

/**
 * XMLRPCリクエストパーサークラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcServerReader.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlRpcServerReader extends SyL_XmlReader
{
    /**
     * メソッド名
     * 
     * @access private
     * @var string
     */
    var $method = '';
    /**
     * 取得パラメータ数
     * 
     * @access private
     * @var int
     */
    var $args_num = 0;
    /**
     * 取得値
     * 
     * @access private
     * @var array
     */
    var $args = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     * ※オーバーライド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $keys = array();
        static $fault_name = '';

        switch ($current_path) {
        case '/methodCall/methodName':
            $this->method = $text;
            break;
        case '/methodCall/params/param':
            $this->args_num++;
            break;
        case '/methodCall/params/param/value/dateTime.iso8601':
        case '/methodCall/params/param/value/string':
        case '/methodCall/params/param/value/base64':
        case '/methodCall/params/param/value/i4':
        case '/methodCall/params/param/value/int':
        case '/methodCall/params/param/value/double':
        case '/methodCall/params/param/value/boolean':
            $format = substr($current_path, strrpos($current_path, '/') + 1);
            $this->args[$this->args_num-1] = $this->formatValue($format, $text);
            break;
        case '/methodCall/params/param/value/array':
        case '/methodCall/params/param/value/struct':
            $this->args[$this->args_num-1] = array();
            break;
        case '/methodCall/params/param/value/struct/member/name':
            $keys = array();
            $keys[0] = $text;
            break;

        default:
            if (preg_match('/^\/methodCall\/params\/param\/value\/(.*)array\/data\/value$/', $current_path)) {
                if ($text !== null) {
                    $i = substr_count($current_path, 'value') - 1;
                    if (!isset($keys[$i])) {
                        $keys[$i] = 0;
                    } else {
                        $keys[$i]++;
                    }
                    $text = $this->formatValue('string', $text);
                    call_user_func_array(array(&$this, 'setCurrentValue'), array_merge((array)$text, $keys));
                }

            } else if (preg_match('/^\/methodCall\/params\/param\/value\/(.*)array\/data\/value\/(string|i4|int|double|boolean|dateTime\.iso8601|base64)$/', $current_path, $matches)) {
                $i = substr_count($current_path, 'value') - 1;
                if (!isset($keys[$i])) {
                    $keys[$i] = 0;
                } else {
                    $keys[$i]++;
                }
                $format = array_pop($matches);
                $text = $this->formatValue($format, $text);
                call_user_func_array(array(&$this, 'setCurrentValue'), array_merge((array)$text, $keys));

            } else if (preg_match('/^\/methodCall\/params\/param\/value\/(.*)struct\/member\/name$/', $current_path, $matches)) {
                $i = substr_count($current_path, 'value');
                $keys[$i] = $text;

            } else if (preg_match('/^\/methodCall\/params\/param\/value\/(.*)struct\/member\/value$/', $current_path, $matches)) {
                if ($text !== null) {
                    $text = $this->formatValue('string', $text);
                    call_user_func_array(array(&$this, 'setCurrentValue'), array_merge((array)$text, $keys));
                }
            } else if (preg_match('/^\/methodCall\/params\/param\/value\/(.*)struct\/member\/value\/(string|i4|int|double|boolean|dateTime\.iso8601|base64)$/', $current_path, $matches)) {
                $format = array_pop($matches);
                $text = $this->formatValue($format, $text);
                call_user_func_array(array(&$this, 'setCurrentValue'), array_merge((array)$text, $keys));
            }
        }
    }

    /**
     * パラメータを型変換して取得する
     *
     * @access private
     * @param string 型
     * @param string 値
     * @return mixed 型変換後値
     */
    function formatValue($format, $value)
    {
        switch ($format) {
        case 'i4':
        case 'int':     return (int)$value;
        case 'double':  return (float)$value;
        case 'boolean':
            if (strtolower($value) == 'false') {
                $value = false;
            }
            return (bool)$value;
        case 'base64':
            return base64_decode($value);
        case 'dateTime.iso8601':
            if (preg_match('/^(\d{4})(\d{2})(\d{2})T(\d{2}:\d{2}:\d{2})$/', $value, $matches)) {
                $value = $matches[1] . '/' . $matches[2] . '/' . $matches[3] . ' ' . $matches[4];
            }
        default:
          return (string)$value;
        }
    }

    /**
     * カレントのキー値を取得する
     *
     * @access private
     * @param array キー値配列
     */
    function setCurrentValue($value)
    {
        $keys = '';
        foreach (array_slice(func_get_args(), 1) as $key) {
            if (is_int($key)) {
                $keys .= "[{$key}]";
            } else {
                $keys .= "['{$key}']";
            }
        }
        eval('$this->args[$this->args_num-1]' . $keys . " = '" . $value . "';");
    }

    /**
     * XMLRPCメソッドを取得する
     *
     * @access public
     * @return string XMLRPCメソッド
     */
    function getMethod()
    {
        return $this->method;
    }

    /**
     * XMLRPCパラメータを取得する
     *
     * @access public
     * @return array XMLRPCパラメータ
     */
    function getArgs()
    {
        return $this->args;
    }

    /**
     * XMLRPCパラメータの数を取得する
     *
     * @access public
     * @return int XMLRPCパラメータの数
     */
    function getNumArgs()
    {
        return $this->args_num;
    }
}
