<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriter.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML作成クラス
 */
require_once dirname(__FILE__) . '/../SyL_XmlWriter.php';

/**
 * RSS 作成クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssWriter.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlRssWriter extends SyL_XmlWriter
{
    /**
     * RSSチャネル
     * 
     * @access protected
     * @var array
     */
    var $channel = array();
    /**
     * 画像要素
     * 
     * @access protected
     * @var array
     */
    var $image = array();
    /**
     * テキスト要素
     * 
     * @access protected
     * @var array
     */
    var $textinput = array();
    /**
     * RSチャネルの属性
     * 
     * @access protected
     * @var array
     */
    var $channel_attr = array();
    /**
     * RSSデータ
     * 
     * @access protected
     * @var array
     */
    var $items = array();
    /**
     * RSSデータの属性
     * 
     * @access protected
     * @var array
     */
    var $items_attribute = array();

    /**
     * RSS作成処理
     *
     * @access public
     * @param string XMLバージョン
     */
    function &factory($version='2.0')
    {
        $classname = 'SyL_XmlRssWriter' . str_replace('.', '_', $version);
        $include_file = dirname(__FILE__) . '/Writer/' . $classname . '.php';
        if (!file_exists($include_file)) {
            trigger_error("[SyL error] Rss version not supported ({$version})", E_USER_ERROR);
        }
        include_once $include_file;
        $writer = new $classname();
        return $writer;
    }

    /**
     * チャネル要素をセットする
     * 
     * @access public
     * @param string 要素名
     * @param string 要素値
     * @param array 属性配列
     */
    function setChannel($name, $value, $attributes=array())
    {
        $this->channel[] = array($name, $value);
        if (count($attributes) > 0) {
            $i = count($this->channel) - 1;
            $this->channel_attr[$i] = $attributes;
        }
    }

    /**
     * 画像要素をセットする
     * 
     * @access public
     * @param array 要素配列
     */
    function setImage($value)
    {
        if (!is_array($value)) {
            trigger_error("[SyL error] Invalid args of setImage method", E_USER_ERROR);
        }
        $this->image = $value;
    }

    /**
     * テキスト要素をセットする
     * 
     * @access public
     * @param array テキスト配列
     */
    function setTextInput($value)
    {
        if (!is_array($value)) {
            trigger_error("[SyL error] Invalid args of setTextInput method", E_USER_ERROR);
        }
        $this->textinput = $value;
    }

    /**
     * 項目をセットする
     * 
     * @access public
     * @param string 要素名
     * @param string 要素値
     * @param array 属性配列
     */
    function addItem($values, $attributes=array())
    {
        $this->items[] = $values;
        if (count($attributes) > 0) {
            $this->items_attribute[count($this->items)-1] = $attributes;
        }
    }

    /**
     * RSSを作成する
     * 
     * @access public
     * @param bool パーサーチェックを行うか
     * @return string RSSデータ
     */
    function create($parser_check=false)
    {
        $this->isEol(true);
        $this->setDeclaration();
        // XML作成
        $this->createXml();
        return parent::create($parser_check);
    }

    /**
     * RSS XMLを作成する
     * 
     * @access protected
     */
    function createXml()
    {
    }

    /**
     * RSSの要素を再帰的に作成する
     * 
     * @access protected
     * @param string 要素名
     * @param string 要素値
     */
    function createRecursiveElements($name, $value='', $attributes=array())
    {
        if (is_array($value)) {
            $this->addStartElement($name);
            foreach ($value as $name1 => $value1) {
                $this->createRecursiveElements($name1, $value1, (isset($attributes[$name1]) ? $attributes[$name1] : array()));
            }
            $this->addEndElement();
        } else {
            $this->addElement($name, $attributes, $value);
        }
    }

    /**
     * 時刻フォーマットを変換する
     *
     * @access protected
     * @param string 変換前時刻
     * @return string 変換後時刻
     */
    function convertDateTime($datetime)
    {
        return $datetime;
    }
}
