<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlSitemapReader.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLリーダクラス
 */
require_once dirname(__FILE__) . '/../SyL_XmlReader.php';

/**
 * サイトマップリーダクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlSitemapReader.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlSitemapReader extends SyL_XmlReader
{
    /**
     * URL配列
     * 
     * @access private
     * @var array
     */
    var $urls = array();

    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_XmlSitemapReader()
    {
    }

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        // XML解析結果を取得
        switch ($current_path) {
        case '/urlset/url':            $this->urls[++$i] = array(); break;
        case '/urlset/url/loc':        $this->urls[$i]['loc']        = $text; break;
        case '/urlset/url/lastmod':    $this->urls[$i]['lastmod']    = $text; break;
        case '/urlset/url/changefreq': $this->urls[$i]['changefreq'] = $text; break;
        case '/urlset/url/priority':   $this->urls[$i]['priority']   = $text; break;
        }
    }

    /**
     * URL配列を全て取得する
     *
     * @access public
     * @return array URL配列
     */
    function getUrls()
    {
        return $this->urls;
    }
}
