<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlSitemapWriter.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML作成クラス
 */
require_once dirname(__FILE__) . '/../SyL_XmlWriter.php';

/**
 * RSS 作成クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlSitemapWriter.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlSitemapWriter extends SyL_XmlWriter
{
    /**
     * URL配列
     * 
     * @access protected
     * @var array
     */
    var $urls = array();

    /**
     * URLを追加する
     * 
     * @access public
     * @param string URL
     * @param string 最終更新日時(UNIX Timestamp)
     * @param string ページの更新頻度
     * @param string URL優先度
     */
    function addUrl($loc, $lastmod=null, $changefreq=null, $priority=null)
    {
        if (!$loc) return false;
        if (strlen($loc) > 2048) return false;
        if ($lastmod) {
            if (!preg_match('/^\d+$/', $lastmod)) {
                return false;
            }
            $lastmod = date('Y-m-d\TH:i:s+0900', $lastmod);
        }
        if ($changefreq) {
            switch ($changefreq) {
            case 'always':
            case 'hourly':
            case 'daily':
            case 'weekly':
            case 'monthly':
            case 'yearly':
            case 'never':
            default: return false;
            }
        }
        if ($priority !== null) {
            if (!preg_match('/^(1\.0|0\.[0-9]$/', $priority)) {
                return false;
            }
        }

        $this->urls[] = array(
            'loc'        => $loc,
            'lastmod'    => $lastmod,
            'changefreq' => $changefreq,
            'priority'   => $priority
        );
        return true;
    }

    /**
     * Sitemapを作成する
     * 
     * @access public
     * @param bool パーサーチェックを行うか
     * @return string Sitemapデータ
     */
    function create($parser_check=false)
    {
        $this->isEol(true);
        $this->setDeclaration();
        // XML作成
        $this->createXml();
        return parent::create($parser_check);
    }

    /**
     * RSS XMLを作成する
     * 
     * @access private
     */
    function createXml()
    {
        $this->addStartElement('urlset', array('xmlns' => 'http://www.sitemaps.org/schemas/sitemap/0.9'));
        foreach ($this->urls as $url) {
            $this->addStartElement('url');
            foreach ($url as $name => $value) {
                if ($value !== null) {
                    $this->addElement($name, array(), $value);
                }
            }
            $this->addEndElement();
        }
        $this->addEndElement();
    }
}
