<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlElements.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLツリー作成基底クラス
 */
require_once 'SyL_XmlEntry.php';

/** 
 * XMLツリー作成要素グループクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlElements.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlElements extends SyL_XmlEntry
{
    /**
     * 子要素格納配列
     * 
     * @access private
     * @var array
     */
    var $entry = array();

    /**
     * コンストラクタ
     *
     * @access public
     * @param string 名称
     * @param array 属性配列
     * @param string 値
     * @param bool CDATAセクション挿入フラグ
     */
    function SyL_XmlElement($name=null, $attributes=array(), $text='', $cdata=false)
    {
        parent::SyL_XmlEntry($name, $attributes, $text, $cdata);
    }

    /**
     * 子要素を追加する
     *
     * @access public
     * @param object 子要素
     */
    function add(&$entry)
    {
        $this->entry[] =& $entry;
    }

    /**
     * XML要素を取得する
     *
     * @access public
     * @param bool 改行フラグ
     * @return string XML要素
     */
    function getTree($is_eol=false)
    {
        $element  = '';
        if ($this->comment !== null) {
            $element .= '<!--';
            $element .= htmlspecialchars($this->comment);
            $element .= '-->';
            if ($is_eol) {
                $element .= $this->eol;
            }
        }
        $element .= "<{$this->name}";
        foreach ($this->getAttributes() as $name => $value) {
            $element .= ' ' . $name . '="' . htmlspecialchars($value) . '"';
        }
        $element .= '>';

        if ($this->text !== null) {
            if ($this->cdata) {
                $element .= '<![CDATA[';
            }
            $element .= htmlspecialchars($this->text);
        } else {
            if ($is_eol) {
                $element .= $this->eol;
            }
        }

        foreach ($this->entry as $node) {
            $element .= $node->getTree($is_eol);
        }

        if ($this->cdata) {
            $element .= ']]>';
        }

        $element .= "</{$this->name}>";
        if ($is_eol) {
            $element .= $this->eol;
        }

        return $element;
    }
}
