<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.3 2009/02/14 04:32:56 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DBクラス
 */
SyL_Loader::lib('DB');
/**
 * ファイル処理クラス
 */
SyL_Loader::lib('File');

/**
 * scaffold.php の起動アクションファイル
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.3 2009/02/14 04:32:56 seasonstream Exp $
 * @link      http://syl.jp/
 */
class Index extends AppAction
{
    /**
     * メイン処理
     *
     * @access public
     * @param object データオブジェクト
     * @param object コンテキストオブジェクト
     */
    function execute(&$data, &$context)
    {
        $cmd =& $context->getConsole();

        // バージョンコマンド
        if ($data->is('h') || $data->is('help')) {
            $this->displayHelp($cmd, $data->get(0));
            return;
        // ヘルプコマンド
        } else if ($data->is('v') || $data->is('version')) {
            $this->displayVersion($cmd, $data->get(0));
            return;
        }

        switch (strtolower($data->get(1))) {
        case 'base':
            include_once 'Base.php';
            $obj =& new Base();
            $obj->execute($data, $context);
            break;
        case 'adm':
            include_once 'Adm.php';
            $obj =& new Adm();
            $obj->execute($data, $context);
            break;
        case 'table':
            include_once 'Table.php';
            $obj =& new Table();
            $obj->execute($data, $context);
            break;
        case 'form':
            include_once 'Form.php';
            $obj =& new Form();
            $obj->execute($data, $context);
            break;
        default:
            $this->displayDefault($cmd, $data->get(0));
        }
    }
}
