/*
 * Decompiled with CFR 0.152.
 */
package plugin.sympathy.rss.connect;

import de.nava.informa.core.ChannelBuilderIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.FeedParser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugin.sympathy.rss.util.RESOURCE_CONST;
import plugin.sympathy.rss.xml.Site;
import plugin.sympathy.rss.xml.Urls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssConnect {
    private Map<String, List> _rssMap = new HashMap<String, List>();

    public RssConnect() throws IOException, ParseException {
    }

    public RssConnect(String proxyIp, String proxyPort) {
        System.setProperty(RESOURCE_CONST.PROXY_HOST, proxyIp);
        System.setProperty(RESOURCE_CONST.PROXY_PORT, proxyPort);
    }

    public Map getAllRss(Urls urls) throws IOException, ParseException {
        List<Site> urlList = urls.getSite();
        int i = 0;
        while (i < urlList.size()) {
            Site site = urlList.get(i);
            this._rssMap.put(site.getName(), this.getRss(site.getUrl()));
            ++i;
        }
        return this._rssMap;
    }

    public List<ItemIF> getRss(String rssUrl) throws IOException, ParseException {
        ArrayList<ItemIF> rssList = new ArrayList<ItemIF>();
        URL url = new URL(rssUrl);
        ChannelIF channel = FeedParser.parse((ChannelBuilderIF)new ChannelBuilder(), (URL)url);
        Collection list = channel.getItems();
        ItemIF[] items = list.toArray(new ItemIF[0]);
        int i = 0;
        while (i < items.length) {
            rssList.add(items[i]);
            ++i;
        }
        return rssList;
    }

    public List getRssList(String key) {
        return this._rssMap.get(key);
    }

    public Map<String, List> getRssMap() {
        return this._rssMap;
    }
}

