/*
 * Decompiled with CFR 0.152.
 */
package plugin.sympathy.rss.preferences.table;

import java.io.FileNotFoundException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import plugin.sympathy.rss.preferences.table.SymResultCellModifier;
import plugin.sympathy.rss.preferences.table.SymResultLabelProvider;
import plugin.sympathy.rss.preferences.table.SymResultSorter;
import plugin.sympathy.rss.preferences.table.SynColumnSelectionAdapter;
import plugin.sympathy.rss.util.RESOURCE_CONST;
import plugin.sympathy.rss.xml.OperationUrls;
import plugin.sympathy.rss.xml.Site;
import plugin.sympathy.rss.xml.Urls;

public class SymResultView
extends ViewPart {
    private SelectionListener selectionListener;
    private Button addBtn;
    private Button removeBtn;
    private Text proxyUrlTxt;
    private Text proxyPortTxt;
    private Text intervalTxt;
    private static List<Site> _tableList;
    private TableViewer resultViewer;
    private static int _selected;

    static {
        _selected = -1;
    }

    public SymResultView(Shell parentShell) {
    }

    public void createPartControl(Composite parent) {
        this.createLabel(parent, RESOURCE_CONST.PREFERENCE_PROXY_HOST, 1);
        this.proxyUrlTxt = this.createText(parent, 2);
        this.createLabel(parent, RESOURCE_CONST.PREFERENCE_PROXY_PORT, 1);
        this.proxyPortTxt = this.createText(parent, 2);
        this.createLabel(parent, RESOURCE_CONST.PREFERENCE_PROXY_INTERVAL, 1);
        this.intervalTxt = this.createText(parent, 2);
        this.resultViewer = new TableViewer(parent, 0);
        Table resultTable = this.resultViewer.getTable();
        resultTable.setLinesVisible(true);
        resultTable.setHeaderVisible(true);
        GridData data = new GridData(1808);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)resultTable, 61);
        data.widthHint = Math.max(widthHint, resultTable.computeSize((int)-1, (int)-1, (boolean)true).x);
        data.horizontalSpan = 9;
        resultTable.setLayoutData((Object)data);
        resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SymResultView.this.tableSelectedEvent();
            }
        });
        this.createColumn(resultTable, RESOURCE_CONST.PREFERENCE_CHECK, 20);
        this.createColumn(resultTable, RESOURCE_CONST.PREFERENCE_NAME, 100);
        this.createColumn(resultTable, RESOURCE_CONST.PREFERENCE_URL, 300);
        String[] properties = new String[]{RESOURCE_CONST.PREFERENCE_PROPERTY_CHECK, RESOURCE_CONST.PREFERENCE_PROPERTY_NAME, RESOURCE_CONST.PREFERENCE_PROPERTY_URL};
        this.resultViewer.setColumnProperties(properties);
        CellEditor[] editors = new CellEditor[]{new CheckboxCellEditor((Composite)resultTable), new TextCellEditor((Composite)resultTable), new TextCellEditor((Composite)resultTable)};
        this.resultViewer.setCellEditors(editors);
        this.resultViewer.setCellModifier((ICellModifier)new SymResultCellModifier(this.resultViewer));
        this.resultViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resultViewer.setLabelProvider((IBaseLabelProvider)new SymResultLabelProvider());
        this.resultViewer.setSorter((ViewerSorter)new SymResultSorter());
        try {
            this.resultViewer.setInput(_tableList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addBtn = this.createPushButton(parent, RESOURCE_CONST.PREFERENCE_BTN_ADD, 3);
        this.removeBtn = this.createPushButton(parent, RESOURCE_CONST.PREFERENCE_BTN_DELETE, 3);
    }

    public void doLoad(String contents) throws FileNotFoundException, JAXBException {
        if (_tableList != null) {
            _tableList.clear();
        }
        Urls urls = new OperationUrls().unmarshal(contents);
        this.proxyPortTxt.setText(urls.getProxyPort());
        this.proxyUrlTxt.setText(urls.getProxyIp());
        this.intervalTxt.setText(urls.getInterval());
        _tableList = urls.getSite();
        this.resultViewer.setInput(_tableList);
    }

    public void doDefaultLoad(String contents) throws FileNotFoundException, JAXBException {
        if (_tableList != null) {
            _tableList.clear();
        }
        _tableList = new OperationUrls().unmarshal(contents).getSite();
        this.resultViewer.setInput(_tableList);
    }

    public String doStore() throws JAXBException {
        Urls urls = new Urls();
        urls.setSite(_tableList);
        urls.setInterval(this.intervalTxt.getText());
        urls.setProxyIp(this.proxyUrlTxt.getText());
        urls.setProxyPort(this.proxyPortTxt.getText());
        return new OperationUrls().marshal(urls);
    }

    void tableSelectedEvent() {
        _selected = this.resultViewer.getTable().getSelectionIndex();
    }

    private void createLabel(Composite parent, String name, int span) {
        Label label = new Label(parent, 16384);
        GridData gridData = new GridData(128);
        gridData.horizontalSpan = span;
        label.setLayoutData((Object)gridData);
        label.setText(name);
    }

    private Text createText(Composite parent, int span) {
        Text text = new Text(parent, 2052);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = span;
        text.setLayoutData((Object)gridData);
        return text;
    }

    private void createColumn(Table table, String key, int width) {
        TableColumn col = new TableColumn(table, 16384);
        col.setText(key);
        col.setWidth(width);
        col.addSelectionListener((SelectionListener)new SynColumnSelectionAdapter(this.resultViewer));
    }

    private Button createPushButton(Composite parent, String key, int span) {
        Button button = new Button(parent, 8);
        button.setText(key);
        button.setFont(parent.getFont());
        this.createLayoutData(button, span);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    private void createLayoutData(Button button, int span) {
        GridData data = new GridData(768);
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
    }

    protected int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == SymResultView.this.addBtn) {
                    SymResultView.this.addPressed();
                } else if (widget == SymResultView.this.removeBtn) {
                    SymResultView.this.removePressed();
                }
            }
        };
    }

    void addPressed() {
        _tableList.add(new Site());
        this.resultViewer.setInput(_tableList);
    }

    void removePressed() {
        if (_selected == -1) {
            return;
        }
        _tableList.remove(_selected);
        this.resultViewer.setInput(_tableList);
    }

    public void setFocus() {
    }
}

