package plugin.sympathy.rss.connect;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import de.nava.informa.impl.basic.ChannelBuilder;
import de.nava.informa.parsers.FeedParser;

import plugin.sympathy.rss.util.RESOURCE_CONST;
import plugin.sympathy.rss.xml.Site;
import plugin.sympathy.rss.xml.Urls;


public class RssConnect
{
    private Map <String,List>_rssMap = new HashMap<String,List>();
    
    /**
     * コンストラクタ
     * @param - urls
     * @throws ParseException 
     * */
    public RssConnect ( ) 
    throws  IOException, ParseException
    {}
    
    public RssConnect ( String proxyIp , String proxyPort )
    {
    	System.setProperty(RESOURCE_CONST.PROXY_HOST, proxyIp);
    	System.setProperty(RESOURCE_CONST.PROXY_PORT, proxyPort);
    }
    
    public Map getAllRss ( Urls urls)
    throws IOException, ParseException
    {
    	List urlList = urls.getSite();
		
		for ( int i = 0 ; i < urlList.size() ; i++ )
		{
		    Site site = (Site)urlList.get(i);
		    this._rssMap.put ( site.getName() , this.getRss ( site.getUrl() ) );
		}
		
		return this._rssMap;
    }
    
    /**
     * @param rssUrl
     * @return list
     * @throws ParseException 
     * */
    @SuppressWarnings("unchecked")
	public List<ItemIF> getRss ( String rssUrl ) 
    throws  IOException, ParseException
    {
    	List <ItemIF> rssList = new ArrayList<ItemIF>();
    	
    	URL url = new URL(rssUrl);
		ChannelIF channel = FeedParser.parse(new ChannelBuilder(), url);
		Collection list = channel.getItems();
		
		ItemIF[] items = (ItemIF[]) list.toArray(new ItemIF[0]);

		for (int i = 0; i < items.length; i++) 
		{
			rssList.add(items[i]);
		}
		return rssList;

    }
    
    /**
     * 名前を指定し、
     * 該当のRSS情報の入ったListを返す
     * @param key - 名前
     * @param -_rssList
     * */
    public List getRssList(String key)
    {
    	return this._rssMap.get(key);
    }
    
    /**
     * @return -_rssMap
     * */
    public Map <String,List>getRssMap()
    {
    	return this._rssMap;
    }
}
