package plugin.sympathy.rss.preferences;

import org.eclipse.jface.preference.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;
import plugin.sympathy.rss.Activator;
import plugin.sympathy.rss.preferences.table.SymTableEditor;
import plugin.sympathy.rss.util.RESOURCE_CONST;


public class SymRssPreference extends FieldEditorPreferencePage implements IWorkbenchPreferencePage 
{

	private Composite fieldEditorParent;
    private int style;
    
    public SymRssPreference() 
    {
		super(GRID);
		setPreferenceStore(Activator.getDefault().getPreferenceStore());
		setDescription(RESOURCE_CONST.PREFERENCE_DESCRIPTION);
    }
    
    public void createFieldEditors() 
    {
    	SymTableEditor sym = new SymTableEditor (SymPreferenceConstants.P_STRING , "Keywords:" , this.fieldEditorParent);
    	addField ( sym );
    }
    
    public void init(IWorkbench workbench) 
    {
    } 
    
    @Override
    protected Control createContents(Composite parent)
    {
		this.fieldEditorParent = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 9;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		this.fieldEditorParent.setLayout(layout);
		this.fieldEditorParent.setFont(parent.getFont());
		
		createFieldEditors();
		
		if (style == GRID)
		    super.adjustGridLayout();
		
		super.initialize();
		super.checkState();
		return this.fieldEditorParent;
    }
	
}