package plugin.sympathy.rss.preferences.table;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Item;

import plugin.sympathy.rss.util.RESOURCE_CONST;
import plugin.sympathy.rss.xml.Site;

public class SymCellModifier implements ICellModifier
{
    private TableViewer viewer;

    public SymCellModifier ( TableViewer viewer )
    {
    	this.viewer = viewer;
    }
    
    public boolean canModify(Object element, String property)
    {
    	return true;
    }

    public Object getValue(Object element, String property)
    {
		Site site = (Site) element;
		
		if (RESOURCE_CONST.PREFERENCE_PROPERTY_CHECK.equals(property))
		{
		    if ( RESOURCE_CONST.TRUE.equals ( site.getFlag() ) )
		    	return new Boolean(true);
		    else
		    	return new Boolean(false);
		}
		else if ( RESOURCE_CONST.PREFERENCE_PROPERTY_NAME.equals(property))
			return site.getName();
		else if ( RESOURCE_CONST.PREFERENCE_PROPERTY_URL.equals(property))
			return site.getUrl();
		
		return null;
    }

    public void modify(Object element, String property, Object value)
    {
		if (element instanceof Item)
		    element = ( ( Item ) element).getData();
		
		Site item = (Site) element;
	
		if (RESOURCE_CONST.PREFERENCE_PROPERTY_CHECK.equals(property))
		{
		    if(( ( Boolean ) value ).booleanValue())
		    	item.setFlag ( RESOURCE_CONST.TRUE );
		    else
		    	item.setFlag ( RESOURCE_CONST.FALSE );
		}
		else if ( RESOURCE_CONST.PREFERENCE_PROPERTY_NAME.equals(property))
			item.setName((String)value);
		else if ( RESOURCE_CONST.PREFERENCE_PROPERTY_URL.equals(property))
			item.setUrl((String)value);
		
		viewer.update(element, null);
    }

}
