package plugin.sympathy.rss.preferences.table;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TableColumn;

public class SymColumnSelectionAdapter extends SelectionAdapter {

	TableViewer viewer_;
	
	public SymColumnSelectionAdapter(TableViewer viewer)
	{
		viewer_ = viewer;
	}
	
	public void widgetSelected(SelectionEvent e) 
	{
		TableColumn column = (TableColumn)e.getSource();
		int columnIndex = viewer_.getTable().indexOf(column);
		
		SymSorter symResultSorter = new SymSorter();
		SymSorter nowSorter = (SymSorter)viewer_.getSorter();
		if (nowSorter.getSortType() == SymSorter.SORT_TYPE_DOWN)
			symResultSorter.setSortType(SymSorter.SORT_TYPE_UP);
		else
			symResultSorter.setSortType(SymSorter.SORT_TYPE_DOWN);
		
		symResultSorter.setColumnIndex(columnIndex);
		viewer_.setSorter(symResultSorter);
	}
}
