package plugin.sympathy.rss.preferences.table;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import plugin.sympathy.rss.util.RESOURCE_CONST;
import plugin.sympathy.rss.xml.Site;


public class SymLabelProvider extends LabelProvider implements ITableLabelProvider
{

	public static final String CHECKED_IMAGE 	= RESOURCE_CONST.CHECKED;
	public static final String UNCHECKED_IMAGE  = RESOURCE_CONST.UNCHECKED;
	private static ImageRegistry imageRegistry = new ImageRegistry();

	static
	{
		imageRegistry.put(CHECKED_IMAGE, ImageDescriptor.createFromFile(
				SymView.class, RESOURCE_CONST.CHECKED_ICON
				)
			);
		imageRegistry.put(UNCHECKED_IMAGE, ImageDescriptor.createFromFile(
				SymView.class,RESOURCE_CONST.UNCHECKED_ICON
				)
			);	
	}
	
	private Image getImage(boolean isSelected) 
	{
		String key = isSelected ? CHECKED_IMAGE : UNCHECKED_IMAGE;
		return  imageRegistry.get(key);
	}
	
    public Image getColumnImage(Object element, int columnIndex)
    {
    	if(columnIndex == 0)
    	{
    		if ( RESOURCE_CONST.TRUE.equals(((Site) element).getFlag() ))
    			return getImage(true);
    		else
    			return getImage(false);
    	}
    	return null;
    }

    public String getColumnText(Object element, int columnIndex)
    {
    	Site site = (Site)element;
        String result = "";
        
        switch (columnIndex) 
        {
        	case 0:
        	break;
            case 1:
                result = site.getName();
            break;
            case 2:
                result = site.getUrl();
            break;
        }
        return result;
    }

}
