package plugin.sympathy.rss.preferences.table;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

import plugin.sympathy.rss.xml.Site;

public class SymSorter extends ViewerSorter {
	
	public static final int SORT_TYPE_UP = 1;
	public static final int SORT_TYPE_DOWN = 2;
	
	public static final int SORT_BY_CHECK = 0;
	public static final int SORT_BY_NAME = 1;
	public static final int SORT_BY_URL = 2;
	
	public int sortType_ = SORT_TYPE_UP;
	public int sortKey_ = SORT_BY_CHECK;
	
	public void setSortType(int sortType) 
	{
		sortType_ = sortType;
	}
	
	public int getSortType() 
	{
		return sortType_;
	}
	
	public void setColumnIndex(int sortKey) 
	{
		sortKey_ = sortKey;
	}
	
	public int compare ( Viewer viewer, Object e1, Object e2) 
	{
		Site result1 = (Site)e1;
		Site result2 = (Site)e2;
		
		if (sortKey_ == SORT_BY_CHECK)
		{	
		}
		else if (sortKey_ == SORT_BY_NAME)
		{
			if (sortType_ == SORT_TYPE_UP)
				return result1.getName().compareTo(result2.getName());
			else
				return result1.getName().compareTo(result2.getName()) * -1;
		}
		else if (sortKey_ == SORT_BY_URL)
		{
			if (sortType_ == SORT_TYPE_UP)
				return result1.getUrl().compareTo(result2.getUrl());
			else
				return result1.getUrl().compareTo(result2.getUrl()) * -1;
		}
		return 0;
	}
}
