package plugin.sympathy.rss.preferences.table;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;


public class SymTableEditor extends FieldEditor
{
    
    private SymView tableView;
    /**
     * コンストラクタ
     * @param name
     * @param labelText
     * @param parent
     * */
    public SymTableEditor(String name, String labelText, Composite parent) 
    {
        super.init(name, labelText);
        super.createControl(parent);
    }

    @Override
    protected void adjustForNumColumns(int numColumns)
    {
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns)
    {
		this.tableView = new SymView( parent.getShell());
		tableView.createPartControl(parent);
    }

    @Override
    protected void doLoad()
    {
		try
		{
		    this.tableView.doLoad(getPreferenceStore().getString(getPreferenceName()));
		} 
		catch (Exception e)
		{
		    e.printStackTrace();
		}
    }

    @Override
    protected void doLoadDefault()
    {
    	try
    	{
    		this.tableView.doDefaultLoad(getPreferenceStore().getDefaultString(getPreferenceName()));
    	}
		catch (Exception e)
		{
		    e.printStackTrace();
		}
    }

    @Override
    protected void doStore()
    {
		String contents = null;
		try
		{
		    contents = this.tableView.doStore();
		} 
		catch (Exception e)
		{
		    e.printStackTrace();
		}
		if (contents != null)
		    getPreferenceStore().setValue(getPreferenceName(), contents);
    }

    @Override
    public int getNumberOfControls()
    {
    	return 9;
    }

}
