package plugin.sympathy.rss.preferences.table;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.List;

import javax.xml.bind.JAXBException;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;

import plugin.sympathy.rss.util.RESOURCE_CONST;
import plugin.sympathy.rss.xml.OperationUrls;
import plugin.sympathy.rss.xml.Site;
import plugin.sympathy.rss.xml.Urls;

public class SymView extends ViewPart
{
    /**SelectionListener*/
    private SelectionListener _selectionListener;
    /**追加ボタン*/
    private Button _addBtn;
    /**削除ボタン*/
    private Button _removeBtn;
    /**ProxyUrl*/
    private Text _proxyUrlTxt;
    /**ProxyPort*/
    private Text _proxyPortTxt;
    /**更新間隔*/
    private Text _intervalTxt;
    /**SiteList*/
    private static List<Site> _tableList;
    /**TableViewer*/
    private TableViewer _resultViewer;
    /**選択行*/
    private static int _selected = -1;
    /**ViewのHelperClass*/
    private SymViewUtil _viewUtil = new SymViewUtil();
    
    /**
     * コンストラクタ
     * @param parentShell
     * */
    public SymView( Shell parentShell)
    {
    	super();
    }

    /**
     * Viewの作成
     * @param parent
     * */
    @Override
    public void createPartControl(Composite parent)
    {
    	this._viewUtil.createLabel ( parent , RESOURCE_CONST.PREFERENCE_PROXY_HOST , 1 );
    	this._proxyUrlTxt = this._viewUtil.createText ( parent , 2 );
    	
    	this._viewUtil.createLabel(parent, RESOURCE_CONST.PREFERENCE_PROXY_PORT, 1);
    	this._proxyPortTxt = this._viewUtil.createText(parent, 2);
		
    	this._viewUtil.createLabel(parent, RESOURCE_CONST.PREFERENCE_PROXY_INTERVAL, 1);
    	this._intervalTxt = this._viewUtil.createText(parent, 2);
		
    	this._resultViewer = new TableViewer(parent, SWT.NONE | SWT.FULL_SELECTION);
		
    	Table resultTable = _resultViewer.getTable();

    	resultTable.setLayoutData ( this._viewUtil.createTableLayout ( resultTable ) );
    	resultTable.addMouseListener ( new MouseAdapter()
    	{
    		public void mouseDown(MouseEvent e)
    		{
    			tableSelectedEvent();
    		}
    	});
	
		this._viewUtil.createColumn(resultTable, RESOURCE_CONST.PREFERENCE_CHECK, 20, this._resultViewer);
		this._viewUtil.createColumn(resultTable, RESOURCE_CONST.PREFERENCE_NAME, 100, this._resultViewer);
		this._viewUtil.createColumn(resultTable, RESOURCE_CONST.PREFERENCE_URL, 300, this._resultViewer);
		this._viewUtil.createTableViewer(resultTable, this._resultViewer, this);
		try
		{
		    this._resultViewer.setInput( _tableList);
		} 
		catch( Exception e)
		{
		    e.printStackTrace();
		}
		this._addBtn = createPushButton(parent, RESOURCE_CONST.PREFERENCE_BTN_ADD,3);
		this._removeBtn = createPushButton(parent, RESOURCE_CONST.PREFERENCE_BTN_DELETE,3);	
    }
    
    /**
     * PreferenceのLoad
     * @throws UnsupportedEncodingException 
     * @patam contents
     * */
    public void doLoad(String contents) 
    throws FileNotFoundException, JAXBException, UnsupportedEncodingException
    {
		if( _tableList != null )
		    _tableList.clear();
			
		Urls urls = new OperationUrls().unmarshal(contents);
		this._proxyPortTxt.setText(urls.getProxyPort());
		this._proxyUrlTxt.setText(urls.getProxyIp());
		this._intervalTxt.setText(urls.getInterval());
		_tableList = urls.getSite();
		this._resultViewer.setInput(_tableList);
    }
    
    /**
     * PreferenceのDefaultLoad
     * @param contents
     * @throws UnsupportedEncodingException 
     * */
    public void doDefaultLoad(String contents) 
    throws FileNotFoundException, JAXBException, UnsupportedEncodingException
    {
		if( _tableList != null )
		    _tableList.clear();
			
		_tableList = new OperationUrls().unmarshal(contents).getSite();
		this._resultViewer.setInput(_tableList);
    }
    
    /**
     * Preferenceの保存
     * @return string
     * @throws UnsupportedEncodingException 
     * */
    public String doStore() 
    throws JAXBException, UnsupportedEncodingException
    {
		Urls urls = new Urls(_tableList,this._proxyUrlTxt.getText(),this._proxyPortTxt.getText(),this._intervalTxt.getText());
		return new OperationUrls().marshal(urls,false);
    }
    
    /**
     * 選択されたTableの行番号取得
     * */
    void tableSelectedEvent()
    {
    	_selected = this._resultViewer.getTable().getSelectionIndex();
    }
    
    /**
     * Buttonを作成します。
     * @param parent
     * @param key
     * */
    private Button createPushButton ( Composite parent , String key , int span ) 
    {
        Button button = this._viewUtil.createPushButton(parent, key, span);
        button.addSelectionListener(getSelectionListener());
        return button;
    }
    
    /**
     * SelectionListenerを取得します。
     * @return selectionListener
     * */
    private SelectionListener getSelectionListener() 
    {
        if (_selectionListener == null)
            createSelectionListener();
        
        return _selectionListener;
    }
    
    /**
     * SelectionListenerの作成
     * Add・Removeボタン押下時に
     * */
    public void createSelectionListener() 
    {
	_selectionListener = new SelectionAdapter() 
        {
            public void widgetSelected(SelectionEvent event) 
            {
                Widget widget = event.widget;
                if (widget == _addBtn)
                    addPressed();
                else if (widget == _removeBtn)
                    removePressed();
            }
        };
    }
    
    /**
     * Addボタン押下時の処理
     * */
    void addPressed()
    {
    	_tableList.add(new Site());
    	this._resultViewer.setInput(_tableList);
    }
    
    /**
     * Removeボタン押下時の処理
     * */
    void removePressed()
    {
		if(_selected == -1 )
		    return;
			
		_tableList.remove(_selected);
		this._resultViewer.setInput(_tableList);
    }

    @Override
    public void setFocus()
    {
    }
    
    public void importSite ( List<Site> siteList)
    {
		_tableList.addAll(siteList);
		this._resultViewer.setInput(_tableList);
    }
    
    public boolean isEmpty()
    {
    	return _tableList.isEmpty();
    }
}
