package plugin.sympathy.rss.preferences.table;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

import plugin.sympathy.rss.util.RESOURCE_CONST;

/**
 * View作成のHelperClass
 * */
public class SymViewUtil
{
	/**
	 * TableViewerの作成
	 * @param resultTable
	 * @param resultViewer
	 * @param view
	 * */
	public void createTableViewer(Table resultTable , TableViewer resultViewer , SymView view)
	{
		String[] properties = new String[] { RESOURCE_CONST.PREFERENCE_PROPERTY_CHECK , RESOURCE_CONST.PREFERENCE_PROPERTY_NAME , RESOURCE_CONST.PREFERENCE_PROPERTY_URL};
		resultViewer.setColumnProperties ( properties );
		CellEditor[] editors = new CellEditor[] { new CheckboxCellEditor ( resultTable ) , new TextCellEditor(resultTable),new TextCellEditor(resultTable)};
		resultViewer.setCellEditors ( editors );
		
		resultViewer.addDropSupport ( DND.DROP_MOVE , new Transfer[]{FileTransfer.getInstance()} , new SymDropListener ( view ) );
		resultViewer.addDragSupport ( DND.DROP_MOVE , new Transfer[]{TextTransfer.getInstance()} , new SymDragListener ( view ) );
		
		resultViewer.setContentProvider( new ArrayContentProvider());
		resultViewer.setLabelProvider( new SymLabelProvider());
		resultViewer.setCellModifier(new SymCellModifier(resultViewer));
		resultViewer.setSorter(new SymSorter());
	}
	
	/**
	 * TableLayoutDataの作成
	 * @param resultTable
	 * */
	public GridData createTableLayout(Table resultTable)
	{
		resultTable.setLinesVisible(true);
		resultTable.setHeaderVisible(true);
		GridData data = new GridData ( GridData.FILL_BOTH );
		int widthHint = this.convertHorizontalDLUsToPixels ( resultTable , IDialogConstants.BUTTON_WIDTH );
		data.widthHint = Math.max(widthHint, resultTable.computeSize(SWT.DEFAULT,SWT.DEFAULT, true).x);
		data.horizontalSpan = 9;
		return data;
	}
	
    /**
     * Labelの作成
     * @param parent
     * @param name
     * @param span
     * */
    public void createLabel ( Composite parent , String name , int span)
    {
    	Label label = new Label ( parent , SWT.LEFT );
    	GridData gridData = new GridData ( GridData.HORIZONTAL_ALIGN_END );
    	gridData.horizontalSpan = span;
    	label.setLayoutData ( gridData );
    	label.setText ( name );
    }

    /**
     * Textの作成
     * @param parent
     * @param span
     * */
    public Text createText ( Composite parent , int span)
    {
    	Text text = new Text ( parent , SWT.BORDER | SWT.SINGLE );
    	GridData gridData = new GridData ( GridData.FILL_HORIZONTAL );
    	gridData.grabExcessHorizontalSpace = true;
    	gridData.horizontalSpan = span;
    	text.setLayoutData ( gridData );
    	return text;
    }

    /**
     * Buttonのレイアウトを設定します。
     * @param button
     * */
    public void createLayoutData(Button button , int span)
    {
    	GridData data = new GridData ( GridData.FILL_HORIZONTAL );
    	data.horizontalSpan = span;
        button.setLayoutData(data);
    }

    /**
     * Sizeを算出
     * @param control
     * @param dlus
     * */
    public int convertHorizontalDLUsToPixels(Control control, int dlus) 
    {
        GC gc = new GC(control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
    
        double horizontalDialogUnitSize = averageWidth * 0.25;
    
        return (int) Math.round(dlus * horizontalDialogUnitSize);
    }
    
    /**
     * Buttonを作成します。
     * @param parent
     * @param key
     * */
    public Button createPushButton ( Composite parent , String key , int span ) 
    {
        Button button = new Button ( parent , SWT.PUSH );
        button.setText (  key );
        button.setFont ( parent.getFont() );
        this.createLayoutData(button,span);
        return button;
    }
    
    /**
     * Tableのカラムの作成
     * @param table
     * @param key
     * @param width
     * */
    public void createColumn(Table table , String key , int width,TableViewer resultViewer)
    {
    	TableColumn col = new TableColumn(table, SWT.LEFT);
        col.setText(key);
        col.setWidth(width);
        col.addSelectionListener(new SymColumnSelectionAdapter(resultViewer));
    }
}
