package plugin.sympathy.rss.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.sql.SQLException;

import javax.xml.bind.JAXBException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

import de.nava.informa.core.ParseException;

import plugin.sympathy.rss.Activator;

/**
 * 例外を実行時例外に変更する
 */
public class ExceptionHandler {

    private Shell _parentShell;
    private Exception _e;
    private String _message;
    
    public void exceptionHandlar ( Exception e , Shell parentShell)
    {
	this._parentShell = parentShell;
	this._e = e;
	this.controllException();
    }
    
    public void exceptionHandlar ( Exception e , Shell parentShell , String message )
    {
	this._parentShell = parentShell;
	this._e = e;
	this._message = message;
	this.controllException();
    }
    
    private void controllException()
    {
	if ( this._e instanceof ClassNotFoundException )
	    this.openErrorDialog(ERROR_CODE.CLASS_NOT_FOND_EXCEPTION);
	else if(this._e instanceof IllegalAccessException)
	    this.openErrorDialog(ERROR_CODE.ILLEGAL_ACCESS_EXCEPTION);
	else if(this._e instanceof InvocationTargetException)
	    this.openErrorDialog(ERROR_CODE.INVOCATION_TARGET_EXCEPTION);
	else if(this._e instanceof NoSuchMethodException)
	    this.openErrorDialog(ERROR_CODE.NO_SUCH_METHOD_EXCEPTION);
	else if(this._e instanceof InstantiationException )
	    this.openErrorDialog(ERROR_CODE.INSTANTIATION_EXCEPTION);
	else if(this._e instanceof SQLException)
	    this.openErrorDialog(ERROR_CODE.SQL_EXCEPTION);
	else if(this._e instanceof FileNotFoundException)
	    this.openErrorDialog(ERROR_CODE.FILE_NOT_FOUND_EXCEPTION);
	else if(this._e instanceof JAXBException)
	    this.openErrorDialog(ERROR_CODE.JAXB_EXCEPTION);
	else if(this._e instanceof IllegalArgumentException)
	    this.openErrorDialog(ERROR_CODE.ILLEGAL_ARGUMENT_EXCEPTION);
	else if(this._e instanceof IOException)
	    this.openErrorDialog(ERROR_CODE.IO_EXCEPTION);
	else if(this._e instanceof MalformedURLException)
	    this.openErrorDialog(ERROR_CODE.MALFORMED_URL_EXCEPTION);
	else if(this._e instanceof ParseException)
	    this.openErrorDialog(ERROR_CODE.PARSE_EXCEPTION);
    }
	
    private void openErrorDialog(int errorCode)
    {
	IStatus status = null;
	if ( StringUtil.isNull(this._message))
	    status = new Status ( IStatus.ERROR ,  Activator.PLUGIN_ID , errorCode , this._e.getMessage() , this._e );
	else
	    status = new Status ( IStatus.ERROR ,  Activator.PLUGIN_ID , errorCode , this._e.getMessage() + "\n"+this._message , this._e );
	
	ErrorDialog.openError(_parentShell, RESOURCE_CONST.ERROR_DIALOG_TITLE, RESOURCE_CONST.ERROR_DIALOG_MESSAGE, status);
    }
    
    
}
