#-*- mode:perl; coding:euc-jp -*-
#$Id: common.pm,v 1.1.1.1 2007/04/18 16:16:05 kohju Exp $
#
#------------------------------------
# commonѥå 
#------------------------------------
package common;

use strict;
use Jcode;
use MIME::Base64;
use CGI;
use POSIX qw(tmpnam);
use def;
use servermode;
use config;
use math;
use func;
use counter;
use sp;
use log;

our $htmlflag = 1; #/0:plain 1:html
our $codeflag = "EUC";
our $phandle  = \*STDOUT; #print2filehandle
our $sclevel = 1;
#------------------------------------
# print2
# in  : 0:plain 1:html
# out : 
#------------------------------------
sub print2_init
{
    my ($v1,$v2,$v3) = @_;
    $htmlflag = $v1 if(defined($v1));
    $codeflag = $v2 if(defined($v2));
    $phandle  = $v3 if(defined($v3));
}

#------------------------------------
# print2
# in  : ɽʸ
# out : 
#------------------------------------
sub print2
{
    my ($v) = @_;
    print $phandle &ChangeCode($v);
}

#------------------------------------
# print2l (list print)
# in  : ɽʸ
# out : 
#------------------------------------
sub print2l
{
    my ($v) = @_;
    foreach my $tmp(@$v){
	print $phandle &ChangeCode($tmp);
    }
}

#------------------------------------
# ʸѴ 
# in  : ʸ󡢥 
# out : Ѵʸ 
#------------------------------------
sub ChangeCode
{
    my ($str, $code) = @_;
    $code = $codeflag if(!defined($code)); #ƤʤȤcodeflag
    
    if ($code eq "JIS"){
	$str = Jcode->new($str)->h2z->jis;
    }elsif ($code eq "SJIS"){
	$str = Jcode->new($str)->h2z->sjis;
    }else{ # default
	$str = Jcode->new($str)->h2z->euc;
    }
    return $str;
}

#-----------------
#(@token)δؿϢ
#-----------------
my %HoF1 = (
	    ":add"      => \&math::Sum,
	    ":sub"      => \&math::Sub,
	    ":mul"      => \&math::Mul,
	    ":div"      => \&math::Div,
	    ":gt"       => \&math::gt,
	    ":ge"       => \&math::gte,
	    ":lt"       => \&math::lt,
	    ":le"       => \&math::lte,
	    ":eq"       => \&math::eq,
	    ":ne"       => \&math::ne,
	    ":and"      => \&math::land,
	    ":or"       => \&math::lor,
	    ":not"      => \&math::not,
	    "isnum"     => \&math::isnum,
	    "numeric"   => \&math::Numeric,
	    "trunc"     => \&math::Trunc,
	    "round"     => \&math::Round,
	    "roundup"   => \&math::Roundup,
	    "html"      => \&toHTML,
	    "plain"     => \&toPLAIN,
	    "mime"      => \&toMIME,
	    "textarea"  => \&toTextArea,
	    "concat"    => \&concat,
	    "cmp"       => \&math::Cmp,
	    "if"        => \&math::Cmp,
	    "length"    => \&str_length,
	    "mb_length" => \&str_mb_length,
	    "han2zen"   => \&han2zen,
	    "zen2han"   => \&zen2han,
	    "time"      => \&pTime,
	    "isasc"     => \&isasc,
	    "ismb"      => \&ismb,
	    "ismailaddress"   => \&mail_check,
	    "reg_replace"     => \&reg_replace,
	    "reg_replace_all" => \&reg_replace_all,
	    "reg_match"       => \&reg_match,
	    "print"           => \&print2,
	    "exit"            => \&exit_program,
	    "system"	  => \&fork_subsystem,
	    "crypt"	  => \&exec_crypt,
	    "randstr"     => \&generate_random_password,
	    );

#-----------------
#key, @token)δؿϢ
#-----------------
my %HoF2 = (
	    "forward"     => \&forward,
	    "change"      => \&change,
	    "ifchange"    => \&ifchange,
	    "errtrap"     => \&ifchange,
	    "ifpaste"     => \&ifpaste,
	    "ifinclude"   => \&ifinclude,
	    "paste"       => \&paste,
	    "pasteto"     => \&pasteto,
	    "include"     => \&include,
	    "includeto"   => \&includeto,
	    "cntup"       => \&cntup,
	    "formselect"  => \&formselect,
	    );

#------------------------------------
# ؿ¹
# in  : ֤ʸϢ󡢴ؿ̾
# out : ƴؿ¹Ը
# Ϸ׻̤֤褦ˤ
#------------------------------------
sub func_exec
{
    my ($k, $name, @token) = @_;

    return $HoF1{$name}->(@token) if($HoF1{$name}); 
    return $HoF2{$name}->($k, @token) if($HoF2{$name});


    #ʳΰĴؿ
    if($name eq "disp"){
	return toDISP($token[0], $htmlflag);
    }elsif($name eq "print"){ 
	return &print2l(\@token);
    }else{
	&log::add(2, "common::func_exec", "not support function [$name]");
	&log::Error("̤ؿޤ", "ؿ̾[$name]ѤǤޤ");
	return "err";
    }
}

#------------------------------------
# ȡ֤
# (ȡ̵ϡʸΤޤ֤롣)
# in  : Ѵʸ֤ʸϢ
# out : Ѵʸ
#------------------------------------
sub ChangeTokenHash
{
    my ($src, $k) = @_;
    my $newline="";		# Ѵι 

    while ($src=~/{?\$(\$|([_A-Za-z][_A-Za-z0-9]*)((\.|\|)[A-Za-z][.|A-Za-z0-9]*)?)}?/){
	my $spchar=$1;
	my $varname=$2;
	my $funclist=$3;
	my $left=$'; # '
	$funclist=~s/\|/\./g;
	if($spchar eq "\$"){
	    # $$ν
	    $newline.=$`.'$';
	}else{
	    #ѿŸ
	    print STDERR "list=$spchar / $varname / $funclist\n";
	    $newline.=$`.get_variable(defined($varname)?$varname:""
				      ,defined($funclist)?$funclist:""
				      ,$k);
	}
	$src=$left;
	print STDERR "left src = $src\n";
    }
    return $newline.$src;
}


#------------------------------------
# htmlإå񤭴롣
# in :ʸλ
# out:Ѵʸ
#------------------------------------
sub htmlheaderreplace
{
    my($line, $k) = @_;
    $$line = Jcode->new($$line)->h2z->euc;
    if($$line=~/(^\s*<\s*[Mm][Ee][Tt][Aa]).*charset\s*=\s*([-A-Za-z_]+)/){
	$$line=~s/$2/euc-jp/g; #Ūeuc-jp
    }

    if($$line =~ /<\/[Hh][Ee][Aa][Dd]>/){
	# BASE
	# ̤ͥ postѥ᥿, config.pmν硣̥륹ȥ󥰤ξѤʤ
	if($$k{'_BASE'}){
	    $$line =~ s/<\/[Hh][Ee][Aa][Dd]>/<base href="$$k{'_BASE'}"><\/head>/;
	}elsif($BASE && $BASE ne ""){
	    $$line =~ s/<\/[Hh][Ee][Aa][Dd]>/<base href="$BASE"><\/head>/;
	}
    }
    return $$line;
}

#------------------------------------
# ƥץ졼ȥեƬ᡼إåʬϤ롣
# in  : Ѵʸ֤ʸϢ,senderѤɥᥤ̾
# out : 
#------------------------------------
sub mailheadergen
{
    my ($file, $k, $domain) = @_;#		print OUT Jcode->new($_)->mime_encode;

    my $fh;
    unless (open($fh, $file)){
	&log::add(2, "common::ChangeTokenFile", "template file open error[$file]");
	&log::Error("ե뤬ɤ߹ޤ", "ե뤬¸ߤƤ뤫ΤƲ[$file]");
    }else{
	&log::add(0, "common::ChangeTokenFile", "success open file: $file") if ($LOGLEVEL >= 1);
    }
    while(<$fh>){
	if ($_ eq "\n" || $_ eq "\r\n") {
	    my $query  = new CGI;
	    print2("User-Agent: $SENDER\n".
		   "Content-Type: text/plain; charset=iso-2022-jp\n".
		   "X-SYMREQ-Request-IP: ".$query->remote_host()."\n".
		   "\n");
	    return tell $fh;
	}elsif ($_=~ /^Subject:\s*/
	    || $_=~/^To:\s*/
	    || $_=~/^Cc:\s*/) {
	    # ִǽإå 
	    print2($&.Jcode->new(ChangeTokenHash($', $k))->mime_encode);
	}else{
	    # ִԲǽإå 
	    print2(Jcode->new($_)->mime_encode);
	}
    }
    
    close($fh);
    return 0;
}

#------------------------------------
# ƥץ졼ȥեɤ߹ߡѴȤԤSTDOUT˽Ϥ롣(htmlڡ)
# in  : Ѵʸ֤ʸϢ
# out : 
#------------------------------------
sub ChangeTokenFile
{
    my ($file, $k) = @_;
    &print2_init(1,"EUC",\*STDOUT);
    &_ChangeTokenFile($file, $k);
    &symreq_terminate($k);
}

#------------------------------------
# ƥץ졼ȥեɤ߹ߡѴȤԤOUT˽Ϥ롣(᡼)
# in  : Ѵʸ֤ʸϢʸ
# out : 
#------------------------------------
sub ChangeTokenFileMail
{
    my ($file, $k, $domain) = @_;
    &print2_init(0,"JIS",\*OUT);
    my $ofs = mailheadergen($file, $k, $domain);
    &_ChangeTokenFile($file, $k, $ofs);
}

#------------------------------------
# fileΥȡ֤(symޥб)
# in  : ƥץ졼ȥե֤̾ʸϢ󡢥ƥץ졼ȥեɤ߹߰֡ʥեƬΥեå͡ˡ񤭽Ф⡼(0:print2ǽ񤭽Ф 1:ѴƤ֤ͤȤ֤)
# out : 񤭽Ф⡼ɤѴƤ֤⡼(=1)ΤȤѴƤ֤
#------------------------------------
sub _ChangeTokenFile
{
    my ($file, $k, $ofs, $outmode) = @_;
    $ofs = 0 if(!defined($ofs) || !&math::isnum($ofs));
    if(!defined($outmode)){
	$outmode = 0;
    }else{
	$outmode = 1;
    }
    my $retstr = ""; #$outmode==1ΤȤΤ̣߰롣
    my $fh;
    # TODO: ֤󤳤դùȡǥեȥեɤ߹ߤ롣
    unless (open($fh, $file)){
	&log::add(2, "common::ChangeTokenFile", "template file open error[$file]");
	&log::Error("ե뤬ɤ߹ޤ", "ե뤬¸ߤƤ뤫ΤƲ[$file]");
    }else{
	&log::add(0, "common::ChangeTokenFile", "success open file: $file") if ($LOGLEVEL >= 1);
    }
    seek($fh, $ofs, 0);

    my $normalmode = 1; #0:scriptmode 1:normalmode
    my $scriptendtag  = '\?>'; 
    my $rpn; #rpnѥեϥɥ
    my $fn = tmpnam(); #tmp rpn ե̾
    my $globallinecounter = 0; #ֹ
    my $scriptstartline = 0; #ץȳϹֹ
    while(<$fh>){
	$globallinecounter++;
	s/\r\n?$/\n/g;
	my $least = &htmlheaderreplace(\$_, $k);

	while($least){
	    if($normalmode){
		#normalmode
		if($least =~/<(\?|!--)sym/){ 
		    $sclevel++; #ץȥ٥
		    if($sclevel > $SCRIPTLEVEL){
			&log::add(2, "common::ChangeTokenFile", "script level is too large.");
			&log::Error("ץȤ¿ŸƤӽФ٥뤬¿ޤ", "¿ɤ߹߲ϵ$SCRIPTLEVEL ʲǤʤФʤޤ(ߤγؿ$sclevel)");
		    }
		    $scriptstartline=$globallinecounter;
		    if($1 eq '?'){
			$scriptendtag='\?>';
		    }else{
			$scriptendtag='-->';
		    }

		    #ץȳϵ椬Ȥ
		    $least=$';
		    if($outmode){
			$retstr .= &ChangeCode(ChangeTokenHash($`, $k));
		    }else{
			print2(ChangeTokenHash($`, $k));
		    }
		    $normalmode = 0; #scriptmodeإ

		    #rpn ե륪ץ
		    unless(open($rpn, ">$fn")){
			&log::add(2, "common::ChangeTokenFile", "temporary file [$fn] open error for rpn");
			&log::Error("ƥݥե뤬񤭹ޤ", "temporary file [$fn] open error for rpn");
		    }
		}else{
		    #ץȳϵ椬ʤȤ

		    if($outmode){
			$retstr .= &ChangeCode(ChangeTokenHash($least, $k));
		    }else{
			print2(ChangeTokenHash($least, $k));
		    }

		    $least="";
		}
	    }else{
		#scriptmode
		if($least =~/$scriptendtag/){ 
		    $sclevel--; #ץȥ٥븺
		    #ץȽλ椬Ȥ
		    #ޥå¦򥹥ץȽ
		    $least=$';
		    my $sc = Jcode->new($`)->h2z->euc;
		    $sc =~s/\r?\n?$//g;
		    $sc =~s/^[\s]+//g;
		    print $rpn $sc."\n";

		    close($rpn);
		    rpn($fn,$k,$scriptstartline, $file);
		    unlink ($fn);
		    $normalmode = 1; #normalmodeإ
		}else{
		    #ץȽλ椬ʤȤ		  
		    #̾凉ץȽ
		    my $sc = Jcode->new($least)->h2z->euc;
		    $sc =~s/\r?\n?$//g;
		    $sc =~s/^[\s]+//g;
		    print $rpn $sc."\n";
		    $least="";
		}

	    }
	}

    }
    &rpn_terminate($k, $normalmode);
    close($fh);
    return $retstr;
}

#------------------------------------
# RPNλ
#------------------------------------
sub rpn_terminate
{
    my ($k, $normalmode) = @_;
    if($normalmode != 1){
	&log::add(2, "common::rpn_terminate", "Sym script is not completed yet.");
	&log::Error("symץȤλƤޤ", "Ĥ륿ǧƤ&lt;?symΤȤ?&gt;,&lt;!--symΤȤ--&gt;б륿Ǥ");
    }
}

#------------------------------------
# symreqλ
#------------------------------------
sub symreq_terminate
{
    my ($k) = @_;
    if($htmlflag == 1){
	#html
	&print2(&changeAnchortag(&ChangeTokenHash("\$_TERMINATE", $k)));
    }else{
	#text
	&print2(&ChangeTokenHash("\$_TERMINATE", $k));
    }
}

#------------------------------------
# ѿͤ
# in  : ѿ̾, ؿꥹȡ֤ʸϢ
# out : ѿ
#------------------------------------
sub get_variable
{
    my($token, $funclist, $k)=@_;
    #ؿꥹȤʤȤ϶Ū.dispղä롣
    $funclist=".disp" unless($funclist);

    my @flist = split(/\./, $funclist);
    #ؿꥹȺ֤˼¹
    #ȡǽ˥å
    my $tmp=$$k{$token};
    foreach my $f(@flist){
	next unless($f);
	#Ѵؿ¹
	$tmp=func_exec($k, $f, $tmp);
    }
    return $tmp;
}

#------------------------------------
# rpnޥɼ¹
# in  : rpnե֤̾ʸϢ, ߤιֹ桢ƥץ졼ȥե̾
# out : Ѵʸ 
# ƥץ졼ȥե̾ϥϤѤ롣
#------------------------------------
sub rpn
{
    my ($fn,$k,$linecounter, $templatefile) = @_;
    my $rpnhd;
    open( $rpnhd, "cat $fn | $config::RPNCMD -l$linecounter|") or die "cannot exec rpn\n";
    while(<$rpnhd>){
	chomp;
	&rpn_exec($_,$k,$templatefile) if($_);
    }
    close($rpnhd);
}


#------------------------------------
# ؿȤΤʸ]Ѥ ʻб
# in  : Ѵʸ,]Ѵʸ
# out : Ѵʸ
#------------------------------------
sub func_escape(){
    my ($src, $dummytoken) = @_;
    $src=~s/$dummytoken/\]/g;
    return $src;
}

#------------------------------------
# rpnˤäѴ줿̿ᷲᤷϿ롣
# in  : ޥɹԡ֤ʸϢ󡢥ƥץ졼ȥե̾
# out : Ѵʸ 
#------------------------------------
sub rpn_exec
{
    my ($cmd, $k, $templatefile) = @_;
    my ($least,$to)=split("=>",$cmd);

#TODO:ɽˤбߡȡǻб 
    my $dummytoken = ":jjppcc:";
    $least=~s/\]\]/$dummytoken/g;

#TODO ']'ΰԤƤΤľȡ
    while($least=~/([A-Za-z:][A-Za-z0-9_\-]*)\[([^\[]*)\]/){
#    while($least=~/([A-Za-z:][A-Za-z0-9_\-]*)\[([^\]]+)\]/){
	my $n1 = $1;
	$least=$'; #'

	# $2Ȥ$dummytoken]᤹
	my $t2 = &func_escape($2, $dummytoken);
	my $n2 = $t2; 


	my $v = "";
	if($n1 eq "VAR"){
# ޤƤʤʤ̥ˤ롣
	    $$k{$n2}="" unless(defined($$k{$n2}));
	    &sp::sp_push($$k{$n2});
	}elsif($n1 eq "NUM"){
	    my $n = $n2 + 0;
	    &sp::sp_push($n);
	} elsif ($n1 eq "STR") {
	    my $s = &ChangeTokenHash(&ecc($n2), $k); # ѿѴƤ
	    &sp::sp_push($s);
	} elsif ($n1 eq "QSTR") {
	    my $s = &ecc($n2);		# ѿѴʤ
	    &sp::sp_push($s);
	} elsif ($n1 eq "EXEC") {
	    my @t = split(',', $n2);
	    my @arglist;
	    for (my $i=0;$i<$t[1];$i++) {
		my $str = &sp::sp_pop();
		unshift(@arglist, $str);
	    }
	    $v = &func_exec($k, $t[0], @arglist);
	    &sp::sp_push($v);
	} elsif ($n1 eq "WARNING") {
	    my $str=$n2;
	    $str=~/([0-9]+):\s*([-_.A-Za-z0-9\s]*)/;
	    &log::add(1, "common::rpn_exec", "rpn warning [$str]");
	    &log::Warning("rpn¹ԻWarningޤ", "[$n1] warning code[$n2]");

	} elsif ($n1 eq "ERROR") {
	    my $str=$n2;
	    $str=~/([0-9]+):\s*([-_.A-Za-z0-9\s]*)/;
	    &log::add(2, "common::rpn_exec", "rpn error [$str]");
	    my @st = split(":", $n2);
	    my @er = ("ƥץ졼ȥե롧$templatefile", "ԡ$st[0]","ơ$st[1]");
	    &log::Error("rpn¹Ի˥顼ޤ", @er );
	} else {
	    #rpnsymreqѤǤؿ˰㤤Ȥ˵
	    my @st = split(":", $n2);
	    my @er = ("[$n1]ؿѤǤޤ", "ƥץ졼ȥե롧$templatefile", "ԡ$st[0]","ơ$st[1]");
	    &log::add(2, "common::rpn_exec", "not support function [$n1]");
	    &log::Error("symreqѤǤؿǤϤޤ", @er);
	}
    }

    if ($to){
	my $t = &sp::sp_pop();
	$$k{$to} = $t;
    }

    &sp::sp_flush();
    return;

}

#------------------------------------
# mail
# in  : mail template file, domain, Ѵѥѥ᡼
# out : 
#------------------------------------
sub SendFormMail
{
    my ($templatefile, $domain, $k) = @_;
    my $from="";		# ᡼ɥ쥹
    my $mtaopt="";		# MTAץ
    my $hdl;
    unless (open($hdl, "$templatefile")){
	my @list = split(/\//, $templatefile); #ե̾ڤФ 
	&log::add(2, "common::SendFormMail", "template file open error");
	&log::Error("ե[$list[-1]]ɤ߹ޤ",
		    "ȡ[_MAILFORM]Ϳե뤬¸ߤƤ뤫ΤƲ");	
    }else{
	&log::add(0, "common::SendFormMail", "success open file: $templatefile") if ($LOGLEVEL >= 1);
    }

    #᡼إåʬɬפʾfrom)롣
    if ($MAILFROM) {
	$from=$MAILFROM;
    } else {
	my $line_counter=0;
	while (<$hdl>) {
	    s/\r?\n?$//g;
	    $_ = Jcode->new($_)->h2z->euc;
	    last if($line_counter > $MAILHEADERLINE);
	    if (/^From:\s*(.*)/) {
		my $from_line=$1;
		#٥å
		if($from_line=~/([^<]*)<([^>]+)>/){
		    #̤ǰϤޤ줿
		    $from=$2;
		}else{
		    #̤ʤ
		    $from=$from_line;
		}
		last;
	    }
	    $line_counter++;
	}
    }
    unless(mail_check($from)){
	#᡼륢ɥ쥹ʤ񼰤ä
	&log::add(2, "common::SendFormMail", "From mailaddress is inaccurate.[$from]");
	&log::Error("From᡼륢ɥ쥹Ǥ",
		    "񼰤ǻꤷƤ[$from]");
    }
    close($hdl);

    
    #᡼륨ȤΥץ롣
    if ($MAILENVELOPE_OPT) {
	$mtaopt = $MAILENVELOPE_OPT." ".$from;
    } else {
	$mtaopt = "";
    }

    #᡼륨ȥץ
    unless (open(*OUT,"| $MAILAGENT $mtaopt")){ 
	&log::add(2, "common::SendFormMail", "[$MAILAGENT $mtaopt]cannot execute");
	&log::Error("᡼륨[$MAILAGENT]ưǤޤ",
		    "ǥ顼ȯޤ",
		    "Ǥ$fromפޤǤϢ");
    } else {
	&log::add(0, "common::SendFormMail", "send to [$from]") if ($LOGLEVEL >= 1);
    }

    &ChangeTokenFileMail($templatefile, $k, $domain);
    &symreq_terminate($k);
    close(OUT);

    print2_init(1,"EUC",\*STDOUT); #ǥեȤ᤹
}

#------------------------------------
# CSV 
# in  : λȡѥ졼(ά",")
# out : CSVʸ
#------------------------------------
sub csv_out
{
    my ($list, $sep) = @_;
    $sep = "," unless($sep);
    my ($data, $i);
    my $cnt=0;
    my @outlist = @$list;
    for($i=0;$i<$#outlist;$i++){ 
	my $str = $outlist[$i];
	$str =~ s/\"/\"\"/g; #"""
	$str = "\"$str\"" if ($str=~/\,/);#;   #,¸ߤʤ""ǰϤ
	$data .= "$str$sep";
    }
    $data .= "$outlist[-1]";
}

#------------------------------------
# ѿhiddenˤƼΥڡϤ
# in  : ֤ʸϢѿꥹ
# out : 
#------------------------------------
sub forward
{
    my ($k, @token)=@_;
    my $ret="";
    foreach my $tmp(@token) {
	$tmp =~ s/\"//g;
	$ret .= &ChangeTokenHash("<INPUT TYPE=\"hidden\" NAME=\"$tmp\" VALUE=\"\$$tmp.mime\">\n", $k);
    }
    print2($ret);
    return "";
}


#------------------------------------
# եɤ߹ǽλ
# in  : ֤ʸϢ󡢥ե̾
# out : 
#------------------------------------
sub change
{
    my ($k, $fn) = @_;
    ChangeTokenFile(getRealTemplatePath($fn), $k);
    exit;
}

#------------------------------------
# ɾΤȤեɤ߹ǽλʵ졧errtrap)
# in  : ֤ʸϢ󡢾ե̾
# out : 
#------------------------------------
sub ifchange
{
    my ($k, $cond, $fn) = @_;
    #=== err trap ================================================
    # ʤСߤWEBFORMǻꤵ줿ƥץ졼Ȥ顢
    # 顼ƥץ졼($fn)ڤؤޤ
    # 顼ȥå׸ϡWEBFORMˤޤ
    # δؿϡWEBFORMƬ˵Ҥ뤳Ȥ侩ޤ
    # 顼ڡ
    # ͡ޤ
    if ($cond) {
	change($k, $fn);
    }
    return "";
}

#------------------------------------
# ɾΤȤեɤ߹ࡣѿŸʤ
# in  : ֤ʸϢ󡢾ե̾
# out : 
#------------------------------------
sub ifpaste
{
    my ($k, $cond, $fn) = @_;
    if ($cond) {
	paste($k, $fn);
    }
    return "";
}

#------------------------------------
# ѿŸ˥եɤ߹
# 
# in  : ֤ʸϢ󡢥ե̾
# out : 
#------------------------------------
sub paste
{
    my ($k, @token) = @_;
    print2(pasteto($k, @token));
    return "";
}

#------------------------------------
# եɤ߹ɤ߹Ƥ֤
# 
# in  : ֤ʸϢ󡢥ե̾,ѿŸʤե饰ʻʤ or _FALSEŸ _TRUE:Ÿʤ)
# out : ɤ߹ե
#------------------------------------
sub pasteto
{
    my ($k, @token) = @_;
    $token[0] =~ s/^\s*([A-Za-z0-9_\-\s]+?)\s*$/$1/g;
    $token[0] =~ s/[\r\n]//g;
    my $fn = getRealTemplatePath($token[0]);
    unless (open(INC, $fn)){
	&log::add(2, "common::pasteto", "template file open error: ".getRealTemplatePath($token[0]));
	&log::Error("ե뤬ɤ߹ޤ[$fn]", "ե뤬¸ߤƤ뤫ΤƲ");
    } else {
	&log::add(0, "common::pasteto", "success open file: ".getRealTemplatePath($token[0])) if ($LOGLEVEL >= 1);
    }
    my $ret="";
    while (<INC>) {
	s/\r?\n?$//g;
	my $line = Jcode->new($_)->h2z->euc;
	if($token[1] && $token[1] ne $$k{'_FALSE'}){
	    $ret.=$line."\n";
	}else{
	    $ret.=ChangeTokenHash($line, $k)."\n";
	}
    }
    close(INC);
    return $ret;
}

#------------------------------------
# ѿŸƥեɤ߹ɤ߹Ƥ֤
# ()
# in  : ֤ʸϢ󡢥ե̾
# out : ɤ߹ե
#------------------------------------
sub includeto
{
    my ($k, @token) = @_;
    return &_ChangeTokenFile(&getRealTemplatePath($token[0]), $k, 0, 1);
}

#------------------------------------
# ɾΤȤեɤ߹ࡣѿŸ롣
# in  : ֤ʸϢ󡢾ե̾
# out : 
#------------------------------------
sub ifinclude
{
    my ($k, $cond, $fn) = @_;
    if ($cond) {
	include($k, $fn);
    }
    return "";
}

#------------------------------------
# ѿŸƥեɤ߹
# 
# in  : ֤ʸϢ󡢥ե̾
# out : 
#------------------------------------
sub include
{
    my ($k, @token) = @_;

    _ChangeTokenFile(getRealTemplatePath($token[0]), $k);
}

#------------------------------------
# ȥåפͤϤ
# in  : ֤ʸϢ󡢥ȥե̾
# out : ȥåפ줿
#------------------------------------
sub cntup
{
    my ($k, @token) = @_;
    my $fn = getRealDataPath($token[0]);
    if (defined($token[1])){
	return &counter::up($fn, $token[1]);
    }else{
	return &counter::up($fn);
    }
}

#------------------------------------
# ɽִʺǽΣĤΤִ
# in  : ɽִʸɾʸ
# out : ִ줿ʸ
#------------------------------------
sub reg_replace
{
    my ($pattern, $replacement, $str) = @_;
    return "" unless($pattern && $str); #ɽɾʸɬ
    $str =~s/$pattern/$replacement/e;
    return $str;
}

#------------------------------------
# ɽִʤ٤ִ
# in  : ɽִʸɾʸ
# out : ִ줿ʸ
#------------------------------------
sub reg_replace_all
{
    my ($pattern, $replacement, $str) = @_;
    return "" unless($pattern && $str); #ɽɾʸɬ
    $str =~s/$pattern/$replacement/eg;
    return $str;
}

#------------------------------------
# ɽޥåǽ˥ޥåΤ֤
# in  : ɽɾʸ
# out : ǽ˥ޥåΤ֤
#------------------------------------
sub reg_match
{
    my ($pattern, $str) = @_;
    return "" if(!defined($pattern) ||  !defined($str));
    return "" if($pattern eq "" ||  $str eq "");
    return $& if($str=~/$pattern/);
    return "";
}

#------------------------------------
# ץཪλ
# in  : ޥ
# out : ¹Է
#------------------------------------
sub exit_program
{
    exit;
}

#------------------------------------
# formselect̿
# in  : Ϣѿ̾,ܣܣġܣ
# out : 
# ϢѤֹ椬äƤФˤ
#------------------------------------
sub formselect
{
    my ($k, $varname, @tokenlist) = @_;
    return if(@tokenlist < 1); #Ȥʤäreturn
    my $selectedvalue = $$k{$varname}?$$k{$varname}:"";
    foreach my $token (@tokenlist){
	if(&isincludesepstr($token, $selectedvalue)){
	    print2("  <option value=\"$token\" selected>$token</option>\n");
	}else{
	    print2("  <option value=\"$token\">$token</option>\n");
	}
    }
}

#------------------------------------
# ѥ졼ʸǶڤ줿ʸˤʸ󤬤뤫ɤĴ٤
# in  : Ĵ٤ʸ󡢥ѥ졼ʸǶڤ줿ʸ
# out : TRUE:¸ߤ롿FALSE:¸ߤʤ
#------------------------------------
sub isincludesepstr
{
    my ($str, $liststr) = @_;
    my @list = split($def::PARAMSEP, $liststr);    
    foreach my $s (@list){    
	return $TRUE if($str eq $s);
    }
    return $FALSE;
}

#------------------------------------
# ޥɥ饤󤫤¹Ԥ̿ᡣƥۡ¤ǽͭꡣ
# in  : ¹Ԥ륳ޥɥ饤
# out : TRUE:¸ߤ롿FALSE:¸ߤʤ
#------------------------------------
sub fork_subsystem
{
  my ($line)=@_;
  my $result='';
  if($COMMAND_EXEC eq "ON"){
    open(SYSIN, "$line |") or log::Error("Cannot launch,$line");
    while(<SYSIN>){
      $result.=$_;
    }
    close(SYSIN);
    return $result;
  } else {
    log::Error("Cannot fork command.'$line'. Please check \$COMMAND_EXEC parameter in config.pm.");
  }
}

#------------------------------------
# crypt Ź沽̿
# in  : ¹Ԥ륳ޥɥ饤
# out : TRUE:¸ߤ롿FALSE:¸ߤʤ
#------------------------------------
sub exec_crypt
{
    my ($passwd,$salt)=@_;
    &log::add(2, "common::exec_crypt", "$salt , $passwd");
    return crypt($passwd,$salt);
}

sub generate_random_password 
{
    my $passwordsize = shift;
    $passwordsize--;
    my @alphanumeric = ('a'..'z', 'A'..'Z', 0..9);
    my $randpassword = join '', 
    map $alphanumeric[rand @alphanumeric], 0..$passwordsize;

    return $randpassword;
}

1;
