/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse;

import java.io.IOException;
import org.famteam.synapse.DPPTestCase;
import org.famteam.synapse.GeneratePage;
import org.famteam.synapse.SynapseParameter;
import org.famteam.synapse.SynapseSetupException;
import org.famteam.synapse.analyze.HTMLAnalyzeException;
import org.famteam.synapse.http.FormData;
import org.famteam.synapse.http.RequestWrapper;
import org.famteam.synapse.http.ServerInfo;
import org.famteam.synapse.junction.PageJunctionException;
import org.famteam.synapse.junction.PageJunctionTargetException;
import org.famteam.synapse.permutate.PermutatePageSourceException;
import org.famteam.tools.file.FileUtil;

public class GeneratePageTest
extends DPPTestCase {
    private String expect_index_string;
    private String expect_subfolder_index_string;
    private String expect_null_string;

    protected void setUp() throws Exception {
        this.setupTestHTML();
        this.setupExpectData();
        SynapseParameter.setROOT_USER_CLASS_LOCATION("/Users/keiji/Documents/eclipse/synapse/WEB-INF/classes");
        SynapseParameter.setHTML_FILE_LOCATION("/Users/keiji/Documents/eclipse/synapse/test_data/html/");
    }

    private void setupTestHTML() throws IOException {
        StringBuffer index_html_source = new StringBuffer();
        index_html_source.append("<html>\n");
        index_html_source.append("<head><title>index</title></head>\n");
        index_html_source.append("<body>\n");
        index_html_source.append("<h1>\u6628\u65e5\u306f\u3001\u3055\u3080\u304b\u3063\u305f\u30fc\u3002</h1>\n");
        index_html_source.append("<table>\n");
        index_html_source.append("<tr><td>\u592a\u90ce</td><td>\u78ba\u304b\u306b\uff01\uff01</td></tr>\n");
        index_html_source.append("<tr><td>\u307e\u3055\u308b</td><td>\u5168\u7136\u3002</td></tr>\n");
        index_html_source.append("<tr><td>\u52dd\u306e\u6bcd</td><td>\u307e\u3041\u307e\u3041</td></tr>\n");
        index_html_source.append("</table>\n");
        index_html_source.append("</body>\n");
        index_html_source.append("</html>");
        FileUtil.saveStringToFile((String)"/Users/keiji/Documents/eclipse/synapse/test_data/html/gp_index.html", (String)index_html_source.toString());
        StringBuffer subfolder_index_html_source = new StringBuffer();
        subfolder_index_html_source.append("<html>\n");
        subfolder_index_html_source.append("<head><title>subfolder\u306eindex</title></head>\n");
        subfolder_index_html_source.append("<body>\n");
        subfolder_index_html_source.append("<h1>\u4eca\u65e5\u306f\u3001\u3055\u3080\u304b\u3063\u305f\u30fc\u3002</h1>\n");
        subfolder_index_html_source.append("<table>\n");
        subfolder_index_html_source.append("<tr><td>\u30c8\u30e0</td><td>\u30ab\u30ea\u30d5\u30a9\u30eb\u30cb\u30a2\u306f\u30d9\u30ea\u30fc\u30db\u30c3\u3068\uff01\uff01</td></tr>\n");
        subfolder_index_html_source.append("<tr><td>\u30b8\u30df\u30fc</td><td>\u304a\u30fc\u3001\u30a4\u30a8\u30b9\u3002</td></tr>\n");
        subfolder_index_html_source.append("<tr><td>\u30b5\u30d6</td><td>\u305d\u305d\u30fc\u3002</td></tr>\n");
        subfolder_index_html_source.append("</table>\n");
        subfolder_index_html_source.append("</body>\n");
        subfolder_index_html_source.append("</html>");
        FileUtil.saveStringToFile((String)"/Users/keiji/Documents/eclipse/synapse/test_data/html/subfolder/gp_index.html", (String)subfolder_index_html_source.toString());
    }

    private void setupExpectData() {
        StringBuffer expect_index_sb = new StringBuffer();
        expect_index_sb.append("<html>\n");
        expect_index_sb.append("<head><title>index</title></head>\n");
        expect_index_sb.append("<body>\n");
        expect_index_sb.append("<h1>\u6628\u65e5\u306f\u3001\u3055\u3080\u304b\u3063\u305f\u30fc\u3002</h1>\n");
        expect_index_sb.append("PPS8\u3092\u901a\u904e\u3057\u307e\u3057\u305f\u3002\n");
        expect_index_sb.append("</body>\n");
        expect_index_sb.append("</html>");
        this.expect_index_string = expect_index_sb.toString();
        StringBuffer expect_subfolder_index_sb = new StringBuffer();
        expect_subfolder_index_sb.append("<html>\n");
        expect_subfolder_index_sb.append("<head><title>subfolder\u306eindex</title></head>\n");
        expect_subfolder_index_sb.append("<body>\n");
        expect_subfolder_index_sb.append("\u697d\u3057\u304b\u3063\u305f\u30fc\n");
        expect_subfolder_index_sb.append("<table>\n");
        expect_subfolder_index_sb.append("<tr><td>\u30c8\u30e0</td><td>\u30ab\u30ea\u30d5\u30a9\u30eb\u30cb\u30a2\u306f\u30d9\u30ea\u30fc\u30db\u30c3\u3068\uff01\uff01</td></tr>\n");
        expect_subfolder_index_sb.append("<tr><td>\u30b8\u30df\u30fc</td><td>\u304a\u30fc\u3001\u30a4\u30a8\u30b9\u3002</td></tr>\n");
        expect_subfolder_index_sb.append("<tr><td>\u30b5\u30d6</td><td>\u305d\u305d\u30fc\u3002</td></tr>\n");
        expect_subfolder_index_sb.append("</table>\n");
        expect_subfolder_index_sb.append("</body>\n");
        expect_subfolder_index_sb.append("</html>");
        this.expect_subfolder_index_string = expect_subfolder_index_sb.toString();
        this.expect_null_string = null;
    }

    public void testGpIndex() throws SynapseSetupException, PageJunctionTargetException, PageJunctionException, PermutatePageSourceException, HTMLAnalyzeException, IOException {
        FormData form_data = new FormData();
        form_data.setParameter("generate_parameter", new String[]{"gp_index"});
        RequestWrapper request_wrapper = new RequestWrapper(form_data, null, null, new ServerInfo());
        String actual_page_string = GeneratePage.getPageSource("generate_page_test", request_wrapper);
        GeneratePageTest.assertEquals((String)this.expect_index_string, (String)actual_page_string);
    }

    public void testGpSubfolderIndex() throws SynapseSetupException, PageJunctionTargetException, PageJunctionException, PermutatePageSourceException, HTMLAnalyzeException, IOException {
        FormData form_data = new FormData();
        form_data.setParameter("generate_parameter", new String[]{"gp_subfolder_index"});
        RequestWrapper request_wrapper = new RequestWrapper(form_data, null, null, new ServerInfo());
        String actual_page_string = GeneratePage.getPageSource("generate_page_test", request_wrapper);
        GeneratePageTest.assertEquals((String)this.expect_subfolder_index_string, (String)actual_page_string);
    }

    public void testGpSKIP() throws SynapseSetupException, PageJunctionTargetException, PageJunctionException, PermutatePageSourceException, HTMLAnalyzeException, IOException {
        FormData form_data = new FormData();
        form_data.setParameter("generate_parameter", new String[]{"gp_null"});
        RequestWrapper request_wrapper = new RequestWrapper(form_data, null, null, new ServerInfo());
        String actual_page_string = GeneratePage.getPageSource("generate_page_test", request_wrapper);
        GeneratePageTest.assertEquals((String)this.expect_null_string, (String)actual_page_string);
    }

    public void testNothingHTML() throws SynapseSetupException, PageJunctionTargetException, PageJunctionException, PermutatePageSourceException, HTMLAnalyzeException, IOException {
        FormData form_data = new FormData();
        form_data.setParameter("generate_parameter", new String[]{"gp_nothing_html"});
        RequestWrapper request_wrapper = new RequestWrapper(form_data, null, null, new ServerInfo());
        String actual_page_string = GeneratePage.getPageSource("generate_page_test", request_wrapper);
        GeneratePageTest.assertEquals((String)this.expect_null_string, (String)actual_page_string);
    }
}

