/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.famteam.synapse.SynapseFileObserverTask;
import org.famteam.synapse.SynapseParameter;
import org.famteam.synapse.SynapseSetupException;
import org.famteam.tools.file.FileUtil;

public class SynapseFileObservar {
    private static Logger logger = Logger.getLogger((String)"DppRun");
    private static long[] html_file_last_modifies;
    private static long[] class_file_last_modifies;
    private static Timer file_observer_timer;

    public static void start() throws SynapseSetupException {
        SynapseFileObservar.loadHTMLFiles();
        SynapseFileObservar.loadClassFiles();
        file_observer_timer = new Timer();
        file_observer_timer.schedule((TimerTask)new SynapseFileObserverTask(), SynapseParameter.getOBSERVER_TIME(), SynapseParameter.getOBSERVER_TIME());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start file observer. interval [" + SynapseParameter.getOBSERVER_TIME() + "]."));
        }
    }

    public static void stop() {
        if (file_observer_timer != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Stop file oberver.");
            }
            file_observer_timer.cancel();
        }
    }

    protected static void loadHTMLFiles() throws SynapseSetupException {
        File[] now_html_files = FileUtil.getAllPrefixFile((String)SynapseParameter.getHTML_FILE_LOCATION(), (String)"html");
        SynapseFileObservar.loadHTMLFiles(now_html_files);
    }

    protected static void loadHTMLFiles(File[] now_html_files) throws SynapseSetupException {
        html_file_last_modifies = new long[now_html_files.length];
        int i = 0;
        while (i < now_html_files.length) {
            SynapseFileObservar.html_file_last_modifies[i] = now_html_files[i].lastModified();
            ++i;
        }
    }

    protected static void loadClassFiles() throws SynapseSetupException {
        File[] now_class_files = FileUtil.getAllPrefixFile((String)SynapseParameter.getROOT_USER_CLASS_LOCATION(), (String)"class");
        SynapseFileObservar.loadClassFiles(now_class_files);
    }

    protected static void loadClassFiles(File[] now_class_files) throws SynapseSetupException {
        class_file_last_modifies = new long[now_class_files.length];
        int i = 0;
        while (i < now_class_files.length) {
            SynapseFileObservar.class_file_last_modifies[i] = now_class_files[i].lastModified();
            ++i;
        }
    }

    public static boolean checkHTMLFileTimestamp() throws SynapseSetupException {
        File[] now_html_files = FileUtil.getAllPrefixFile((String)SynapseParameter.getHTML_FILE_LOCATION(), (String)"html");
        if (html_file_last_modifies.length != now_html_files.length) {
            return true;
        }
        int i = 0;
        while (i < html_file_last_modifies.length) {
            if (html_file_last_modifies[i] != now_html_files[i].lastModified()) {
                SynapseFileObservar.loadHTMLFiles(now_html_files);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean checkClassFiles() throws SynapseSetupException {
        File[] now_class_files = FileUtil.getAllPrefixFile((String)SynapseParameter.getROOT_USER_CLASS_LOCATION(), (String)"class");
        if (class_file_last_modifies.length != now_class_files.length) {
            return true;
        }
        int i = 0;
        while (i < class_file_last_modifies.length) {
            if (class_file_last_modifies[i] != now_class_files[i].lastModified()) {
                SynapseFileObservar.loadClassFiles(now_class_files);
                return true;
            }
            ++i;
        }
        return false;
    }
}

