/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse;

import java.io.IOException;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.famteam.synapse.SynapseFileObservar;
import org.famteam.synapse.SynapseSetupException;
import org.famteam.synapse.analyze.HTMLAnalyzeException;
import org.famteam.synapse.analyze.HTMLSourceManager;
import org.famteam.synapse.junction.PageJunctionException;
import org.famteam.synapse.junction.PageJunctionManager;
import org.famteam.synapse.permutate.DynamicHTMLDocumentManager;
import org.famteam.synapse.permutate.PermutatePageSourceException;
import org.famteam.synapse.permutate.PermutatePageSourceManager;

public class SynapseFileObserverTask
extends TimerTask {
    private static Logger logger = Logger.getLogger((String)"DppRun");

    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Check class and html.");
        }
        try {
            boolean html_check_result = SynapseFileObservar.checkHTMLFileTimestamp();
            boolean pps_pj_check_result = SynapseFileObservar.checkClassFiles();
            if (html_check_result) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Reload HTML...");
                }
                HTMLSourceManager.setupHtmlSource();
            }
            if (pps_pj_check_result) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Reload PPS and PJ...");
                }
                PermutatePageSourceManager.setupPermutatePageSource();
                PageJunctionManager.setupPageJunction();
            }
            if (html_check_result || pps_pj_check_result) {
                DynamicHTMLDocumentManager.setUp();
            }
        }
        catch (SynapseSetupException e) {
            logger.warn((Object)"DPPFileObserverTask error.", (Throwable)e);
        }
        catch (HTMLAnalyzeException e) {
            logger.warn((Object)"DPPFileObserverTask error.", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn((Object)"DPPFileObserverTask error.", (Throwable)e);
        }
        catch (PermutatePageSourceException e) {
            logger.warn((Object)"DPPFileObserverTask error.", (Throwable)e);
        }
        catch (PageJunctionException e) {
            logger.warn((Object)"DPPFileObserverTask error.", (Throwable)e);
        }
    }
}

