/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.analyze;

import junit.framework.TestCase;
import org.famteam.synapse.analyze.HTMLAnalyzeException;
import org.famteam.synapse.analyze.HTMLBlockTag;
import org.famteam.synapse.analyze.HTMLDocument;
import org.famteam.synapse.analyze.HTMLSourceAnalyzer;
import org.famteam.synapse.analyze.HTMLText;

public class HTMLSourceAnalyzerTest
extends TestCase {
    private HTMLDocument expect_html_document;
    private String test_source_data;

    protected void setUp() throws Exception {
        StringBuffer test_source_string_buffer = new StringBuffer();
        test_source_string_buffer.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        test_source_string_buffer.append("<body>");
        test_source_string_buffer.append("\u3042\u3042\u3042");
        test_source_string_buffer.append("<div id=\"first\">");
        test_source_string_buffer.append("\u3044\u3044\u3044");
        test_source_string_buffer.append("</div>");
        test_source_string_buffer.append("\u3046\u3046\u3046");
        test_source_string_buffer.append("<div>");
        test_source_string_buffer.append("\u3048\u3048\u3048");
        test_source_string_buffer.append("<div>\u304a\u304a\u304a</div>");
        test_source_string_buffer.append("\u304b\u304b\u304b");
        test_source_string_buffer.append("</div>");
        test_source_string_buffer.append("\u304d\u304d\u304d");
        test_source_string_buffer.append("</body>");
        this.test_source_data = test_source_string_buffer.toString();
        this.expect_html_document = new HTMLDocument();
        this.expect_html_document.setDoctype_string("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        HTMLBlockTag expect_body = new HTMLBlockTag();
        expect_body.setTag_name("body");
        expect_body.setTag_text("body");
        this.expect_html_document.setHtml_block_tag(expect_body);
        HTMLText body_text1 = new HTMLText("\u3042\u3042\u3042");
        expect_body.addChild(body_text1);
        HTMLBlockTag body_div1 = new HTMLBlockTag();
        body_div1.setTag_name("div");
        body_div1.setTag_text("div id=\"first\"");
        expect_body.addChild(body_div1);
        HTMLText body_div1_text1 = new HTMLText("\u3044\u3044\u3044");
        body_div1.addChild(body_div1_text1);
        HTMLText body_text2 = new HTMLText("\u3046\u3046\u3046");
        expect_body.addChild(body_text2);
        HTMLBlockTag body_div2 = new HTMLBlockTag();
        body_div2.setTag_name("div");
        body_div2.setTag_text("div");
        expect_body.addChild(body_div2);
        HTMLText body_div2_text1 = new HTMLText("\u3048\u3048\u3048");
        body_div2.addChild(body_div2_text1);
        HTMLBlockTag body_div2_div1 = new HTMLBlockTag();
        body_div2_div1.setTag_name("div");
        body_div2_div1.setTag_text("div");
        body_div2.addChild(body_div2_div1);
        HTMLText body_div2_div1_text1 = new HTMLText("\u304a\u304a\u304a");
        body_div2_div1.addChild(body_div2_div1_text1);
        HTMLText body_div2_text2 = new HTMLText("\u304b\u304b\u304b");
        body_div2.addChild(body_div2_text2);
        HTMLText body_text3 = new HTMLText("\u304d\u304d\u304d");
        expect_body.addChild(body_text3);
    }

    public void testAnalyzeHTMLSource() throws HTMLAnalyzeException {
        HTMLDocument html_document = HTMLSourceAnalyzer.analyzeHTMLSource(this.test_source_data, "");
        HTMLSourceAnalyzerTest.assertEquals((Object)this.expect_html_document, (Object)html_document);
    }
}

