/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.analyze;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.famteam.synapse.SynapseParameter;
import org.famteam.synapse.SynapseSetupException;
import org.famteam.synapse.analyze.HTMLAnalyzeException;
import org.famteam.synapse.analyze.HTMLDocument;
import org.famteam.synapse.analyze.HTMLSourceAnalyzer;
import org.famteam.tools.file.FileUtil;

public class HTMLSourceManager {
    private static Logger logger = Logger.getLogger((String)"DppSetup");
    private static Logger logger_ll = Logger.getLogger((String)"LoadLog");
    private static Map html_source_map = null;

    public static void setupHtmlSource() throws HTMLAnalyzeException, IOException, SynapseSetupException {
        html_source_map = new HashMap();
        File[] all_html_files = FileUtil.getAllPrefixFile((String)SynapseParameter.getHTML_FILE_LOCATION(), (String)"html");
        int i = 0;
        while (i < all_html_files.length) {
            String now_html_file_name = HTMLSourceManager.getHTMLName(SynapseParameter.getHTML_FILE_LOCATION(), all_html_files[i].getPath());
            HTMLDocument now_html_document = HTMLSourceAnalyzer.analyzeHTMLSource(FileUtil.getFileText((String)all_html_files[i].getPath(), (String)SynapseParameter.getFORM_DATA_ENCODING()), now_html_file_name);
            html_source_map.put(now_html_document.getHtml_file_name(), now_html_document);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("load html file > " + now_html_document.getHtml_file_name()));
            }
            ++i;
        }
        HTMLSourceManager.saveLog();
    }

    private static String getHTMLName(String html_location, String file_path) {
        return file_path.substring(html_location.length());
    }

    public static List getHTMLSources() throws HTMLAnalyzeException, IOException, SynapseSetupException {
        if (html_source_map == null) {
            HTMLSourceManager.setupHtmlSource();
        }
        return new Vector(html_source_map.values());
    }

    public static HTMLDocument getHTMLDocument(String html_file_name) throws HTMLAnalyzeException, IOException, SynapseSetupException {
        if (html_source_map == null) {
            HTMLSourceManager.setupHtmlSource();
        }
        return (HTMLDocument)html_source_map.get(html_file_name);
    }

    private static void saveLog() {
        if (logger_ll.isDebugEnabled()) {
            logger_ll.debug((Object)"HTML Load log.\n");
            Iterator pps_key_ite = html_source_map.keySet().iterator();
            while (pps_key_ite.hasNext()) {
                String now_key = (String)pps_key_ite.next();
                logger_ll.debug((Object)new StringBuffer(now_key).append("\n"));
            }
        }
        logger_ll.debug((Object)"\n");
    }
}

