/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.analyze;

import junit.framework.TestCase;
import org.famteam.synapse.analyze.HTMLAnalyzeException;
import org.famteam.synapse.analyze.TagSearcher;

public class TagSearcherTest
extends TestCase {
    private String test_source;

    protected void setUp() throws Exception {
        StringBuffer test_source_string_buffer = new StringBuffer();
        test_source_string_buffer.append("<body>");
        test_source_string_buffer.append("\u3042\u3042\u3042");
        test_source_string_buffer.append("<div id=\"first\">");
        test_source_string_buffer.append("\u3044\u3044\u3044");
        test_source_string_buffer.append("<img src=\"\"/>");
        test_source_string_buffer.append("</div>");
        test_source_string_buffer.append("\u3046\u3046\u3046");
        test_source_string_buffer.append("<div>");
        test_source_string_buffer.append("\u3048\u3048\u3048");
        test_source_string_buffer.append("<div>\u304a\u304a\u304a</div>");
        test_source_string_buffer.append("\u304b\u304b\u304b");
        test_source_string_buffer.append("</div>");
        test_source_string_buffer.append("\u304d\u304d\u304d");
        test_source_string_buffer.append("</body>");
        this.test_source = test_source_string_buffer.toString();
    }

    public void testTagSearcher() throws HTMLAnalyzeException {
        TagSearcher tag_searcher = new TagSearcher(this.test_source);
        TagSearcherTest.assertTrue((boolean)tag_searcher.nextTag());
        this.assertBodyTagSearcher(tag_searcher);
        TagSearcherTest.assertTrue((boolean)tag_searcher.nextTag());
        this.assertDiv1TagSearcher(tag_searcher);
        TagSearcherTest.assertTrue((boolean)tag_searcher.nextTag());
        this.assertDiv2TagSearcher(tag_searcher);
    }

    private void assertBodyTagSearcher(TagSearcher tag_searcher) throws HTMLAnalyzeException {
        String expect_tag_name = "body";
        String expect_tag_text = "body";
        StringBuffer expect_before_text = new StringBuffer();
        StringBuffer expect_inner_text = new StringBuffer();
        expect_inner_text.append("\u3042\u3042\u3042");
        expect_inner_text.append("<div id=\"first\">");
        expect_inner_text.append("\u3044\u3044\u3044");
        expect_inner_text.append("<img src=\"\"/>");
        expect_inner_text.append("</div>");
        expect_inner_text.append("\u3046\u3046\u3046");
        expect_inner_text.append("<div>");
        expect_inner_text.append("\u3048\u3048\u3048");
        expect_inner_text.append("<div>\u304a\u304a\u304a</div>");
        expect_inner_text.append("\u304b\u304b\u304b");
        expect_inner_text.append("</div>");
        expect_inner_text.append("\u304d\u304d\u304d");
        StringBuffer expect_after_text = new StringBuffer();
        TagSearcherTest.assertEquals((String)expect_tag_name, (String)tag_searcher.getTagName());
        TagSearcherTest.assertEquals((String)expect_tag_text, (String)tag_searcher.getTagText());
        TagSearcherTest.assertEquals((String)expect_before_text.toString(), (String)tag_searcher.getNowBeforeText());
        TagSearcherTest.assertEquals((String)expect_inner_text.toString(), (String)tag_searcher.getNowInnerText());
        TagSearcherTest.assertEquals((String)expect_after_text.toString(), (String)tag_searcher.getNowAfterText());
    }

    private void assertDiv1TagSearcher(TagSearcher tag_searcher) throws HTMLAnalyzeException {
        String expect_tag_name = "div";
        String expect_tag_text = "div id=\"first\"";
        StringBuffer expect_before_text = new StringBuffer();
        expect_before_text.append("<body>");
        expect_before_text.append("\u3042\u3042\u3042");
        StringBuffer expect_inner_text = new StringBuffer();
        expect_inner_text.append("\u3044\u3044\u3044");
        expect_inner_text.append("<img src=\"\"/>");
        StringBuffer expect_after_text = new StringBuffer();
        expect_after_text.append("\u3046\u3046\u3046");
        expect_after_text.append("<div>");
        expect_after_text.append("\u3048\u3048\u3048");
        expect_after_text.append("<div>\u304a\u304a\u304a</div>");
        expect_after_text.append("\u304b\u304b\u304b");
        expect_after_text.append("</div>");
        expect_after_text.append("\u304d\u304d\u304d");
        expect_after_text.append("</body>");
        TagSearcherTest.assertEquals((String)expect_tag_name, (String)tag_searcher.getTagName());
        TagSearcherTest.assertEquals((String)expect_tag_text, (String)tag_searcher.getTagText());
        TagSearcherTest.assertEquals((String)expect_before_text.toString(), (String)tag_searcher.getNowBeforeText());
        TagSearcherTest.assertEquals((String)expect_inner_text.toString(), (String)tag_searcher.getNowInnerText());
        TagSearcherTest.assertEquals((String)expect_after_text.toString(), (String)tag_searcher.getNowAfterText());
    }

    private void assertDiv2TagSearcher(TagSearcher tag_searcher) throws HTMLAnalyzeException {
        String expect_tag_name = "div";
        String expect_tag_text = "div";
        StringBuffer expect_before_text = new StringBuffer();
        expect_before_text.append("<body>");
        expect_before_text.append("\u3042\u3042\u3042");
        expect_before_text.append("<div id=\"first\">");
        expect_before_text.append("\u3044\u3044\u3044");
        expect_before_text.append("<img src=\"\"/>");
        expect_before_text.append("</div>");
        expect_before_text.append("\u3046\u3046\u3046");
        StringBuffer expect_inner_text = new StringBuffer();
        expect_inner_text.append("\u3048\u3048\u3048");
        expect_inner_text.append("<div>\u304a\u304a\u304a</div>");
        expect_inner_text.append("\u304b\u304b\u304b");
        StringBuffer expect_after_text = new StringBuffer();
        expect_after_text.append("\u304d\u304d\u304d");
        expect_after_text.append("</body>");
        TagSearcherTest.assertEquals((String)expect_tag_name, (String)tag_searcher.getTagName());
        TagSearcherTest.assertEquals((String)expect_tag_text, (String)tag_searcher.getTagText());
        TagSearcherTest.assertEquals((String)expect_before_text.toString(), (String)tag_searcher.getNowBeforeText());
        TagSearcherTest.assertEquals((String)expect_inner_text.toString(), (String)tag_searcher.getNowInnerText());
        TagSearcherTest.assertEquals((String)expect_after_text.toString(), (String)tag_searcher.getNowAfterText());
    }
}

