/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.famteam.synapse.SynapseParameter;
import org.famteam.synapse.http.FormData;
import org.famteam.synapse.http.FormDataException;
import org.famteam.synapse.http.UploadFile;

public class FormDataMaker {
    public static FormData getFormData(HttpServletRequest request) throws FormDataException {
        FormData form_data = new FormData();
        try {
            request.setCharacterEncoding(SynapseParameter.getFORM_DATA_ENCODING());
        }
        catch (UnsupportedEncodingException e1) {
            throw new FormDataException();
        }
        if (FileUploadBase.isMultipartContent((HttpServletRequest)request)) {
            try {
                DiskFileUpload upload = new DiskFileUpload();
                upload.setSizeMax((long)SynapseParameter.getUPLOAD_FILE_SIZE_LIMIT());
                upload.setRepositoryPath(SynapseParameter.getUPLOAD_FILE_TEMP_FOLDER());
                upload.setHeaderEncoding(SynapseParameter.getFORM_DATA_ENCODING());
                List file_item_list = upload.parseRequest(request);
                Iterator file_item_iterator = file_item_list.iterator();
                while (file_item_iterator.hasNext()) {
                    String now_field_name;
                    FileItem now_file_item = (FileItem)file_item_iterator.next();
                    if (now_file_item.isFormField()) {
                        now_field_name = now_file_item.getFieldName();
                        String[] now_value = now_file_item.getString(SynapseParameter.getFORM_DATA_ENCODING()).split(",");
                        form_data.setParameter(now_field_name, now_value);
                        continue;
                    }
                    now_field_name = now_file_item.getFieldName();
                    String client_file_name = now_file_item.getName();
                    if (client_file_name == null || client_file_name.equals("")) continue;
                    form_data.setParameter(now_field_name, new UploadFile(client_file_name, now_file_item.getInputStream(), now_file_item.getSize()));
                }
            }
            catch (FileUploadBase.SizeLimitExceededException e) {
                throw new FormDataException();
            }
            catch (IOException e) {
                throw new FormDataException();
            }
            catch (FileUploadException e) {
                throw new FormDataException();
            }
        } else {
            Enumeration request_keys = request.getParameterNames();
            while (request_keys.hasMoreElements()) {
                String now_key = (String)request_keys.nextElement();
                form_data.setParameter(now_key, request.getParameterValues(now_key));
            }
        }
        return form_data;
    }
}

