/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.junction;

import java.util.HashMap;
import org.famteam.synapse.DPPTestCase;
import org.famteam.synapse.SynapseParameter;
import org.famteam.synapse.SynapseSetupException;
import org.famteam.synapse.junction.PageJunctionException;
import org.famteam.synapse.junction.PageJunctionList;
import org.famteam.synapse.junction.PageJunctionManager;
import org.famteam.synapse.junction.PageJunctionMap;
import org.famteam.synapse.junction.PageJunctionTarget;
import org.famteam.synapse.junction.PageJunctionTargetException;
import org.famteam.synapse.junction.Test1PageJunction;
import org.famteam.synapse.junction.Test2PageJunction;
import org.famteam.synapse.junction.Test3PageJunction;
import org.famteam.synapse.junction.Test4PageJunction;
import org.famteam.synapse.junction.Test5PageJunction;
import org.famteam.synapse.junction.Test6PageJunction;

public class PageJunctionManagerTest
extends DPPTestCase {
    private static final String test_html_name1 = "index";
    private static final String test_html_name2 = "contents/index";
    private static final String test_html_name3 = "navigator/index";
    private static final String test_html_name4 = "other";
    private static PageJunctionList expect_pj_list1 = null;
    private static PageJunctionList expect_pj_list2 = null;
    private static PageJunctionList expect_pj_list3 = null;
    private static PageJunctionList expect_pj_list4 = null;
    private static PageJunctionMap expect_pj_map = null;

    protected void setUp() throws Exception {
        SynapseParameter.setROOT_USER_CLASS_LOCATION("/Users/keiji/Documents/eclipse/synapse/WEB-INF/classes");
        this.setupExpectPageJunctionMap();
        this.setupExpectPageJunctionList();
    }

    public void testSetup() throws SynapseSetupException, PageJunctionException {
        PageJunctionManagerTest.assertEquals((Object)expect_pj_map, (Object)PageJunctionManager.getPageJunctionMap());
    }

    public void testGetPageJunctions1() throws SynapseSetupException, PageJunctionTargetException, PageJunctionException {
        PageJunctionList actual_pj_list = PageJunctionManager.getPageJunctions(test_html_name1);
        PageJunctionManagerTest.assertEquals((Object)expect_pj_list1, (Object)actual_pj_list);
    }

    public void testGetPageJunctions2() throws SynapseSetupException, PageJunctionTargetException, PageJunctionException {
        PageJunctionList actual_pj_list = PageJunctionManager.getPageJunctions(test_html_name2);
        PageJunctionManagerTest.assertEquals((Object)expect_pj_list2, (Object)actual_pj_list);
    }

    public void testGetPageJunctions3() throws SynapseSetupException, PageJunctionTargetException, PageJunctionException {
        PageJunctionList actual_pj_list = PageJunctionManager.getPageJunctions(test_html_name3);
        PageJunctionManagerTest.assertEquals((Object)expect_pj_list3, (Object)actual_pj_list);
    }

    public void testGetPageJunctions4() throws SynapseSetupException, PageJunctionTargetException, PageJunctionException {
        PageJunctionList actual_pj_list = PageJunctionManager.getPageJunctions(test_html_name4);
        PageJunctionManagerTest.assertEquals((Object)expect_pj_list4, (Object)actual_pj_list);
    }

    private void setupExpectPageJunctionMap() throws PageJunctionException {
        Test1PageJunction test1_pj = new Test1PageJunction();
        Test2PageJunction test2_pj = new Test2PageJunction();
        Test3PageJunction test3_pj = new Test3PageJunction();
        Test4PageJunction test4_pj = new Test4PageJunction();
        Test5PageJunction test5_pj = new Test5PageJunction();
        Test6PageJunction test6_pj = new Test6PageJunction();
        PageJunctionList pj_index_list = new PageJunctionList();
        pj_index_list.addPageJunction(test1_pj);
        PageJunctionList pj_contents_index_list = new PageJunctionList();
        pj_contents_index_list.addPageJunction(test1_pj);
        PageJunctionList pj_navigator_index_list = new PageJunctionList();
        pj_navigator_index_list.addPageJunction(test1_pj);
        pj_navigator_index_list.addPageJunction(test2_pj);
        PageJunctionList pj_blog_index_list = new PageJunctionList();
        pj_blog_index_list.addPageJunction(test2_pj);
        PageJunctionList pj_asterisk_list = new PageJunctionList();
        pj_asterisk_list.addPageJunction(test3_pj);
        PageJunctionList pj_gp_list = new PageJunctionList();
        pj_gp_list.addPageJunction(test4_pj);
        pj_gp_list.addPageJunction(test5_pj);
        pj_gp_list.addPageJunction(test6_pj);
        expect_pj_map = new PageJunctionMap();
        HashMap<PageJunctionTarget, PageJunctionList> expect_inner_map = new HashMap<PageJunctionTarget, PageJunctionList>();
        expect_inner_map.put(new PageJunctionTarget(test_html_name1), pj_index_list);
        expect_inner_map.put(new PageJunctionTarget(test_html_name2), pj_contents_index_list);
        expect_inner_map.put(new PageJunctionTarget(test_html_name3), pj_navigator_index_list);
        expect_inner_map.put(new PageJunctionTarget("blog/index"), pj_blog_index_list);
        expect_inner_map.put(new PageJunctionTarget(".*"), pj_asterisk_list);
        expect_inner_map.put(new PageJunctionTarget("generate_page_test"), pj_gp_list);
        expect_pj_map.setMap(expect_inner_map);
    }

    private void setupExpectPageJunctionList() throws PageJunctionException {
        Test1PageJunction test1_pj = new Test1PageJunction();
        Test2PageJunction test2_pj = new Test2PageJunction();
        Test3PageJunction test3_pj = new Test3PageJunction();
        expect_pj_list1 = new PageJunctionList();
        expect_pj_list1.addPageJunction(test1_pj);
        expect_pj_list1.addPageJunction(test3_pj);
        expect_pj_list2 = new PageJunctionList();
        expect_pj_list2.addPageJunction(test1_pj);
        expect_pj_list2.addPageJunction(test3_pj);
        expect_pj_list3 = new PageJunctionList();
        expect_pj_list3.addPageJunction(test1_pj);
        expect_pj_list3.addPageJunction(test2_pj);
        expect_pj_list3.addPageJunction(test3_pj);
        expect_pj_list4 = new PageJunctionList();
        expect_pj_list4.addPageJunction(test3_pj);
    }
}

