/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.permutate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.famteam.synapse.SaveSynapseInfo;
import org.famteam.synapse.SynapseParameter;
import org.famteam.synapse.analyze.HTMLElement;
import org.famteam.synapse.http.CookieData;
import org.famteam.synapse.http.FormData;
import org.famteam.synapse.http.ServerInfo;
import org.famteam.synapse.http.SessionData;
import org.famteam.synapse.permutate.PermutatePageSourceException;
import org.famteam.synapse.permutate.PermutateTarget;

public abstract class PermutatePageSource
extends HTMLElement {
    private Map permutate_targets_map;
    protected String old_page_source;

    public PermutateTarget getPermutateTargetText(String html_file_name) throws PermutatePageSourceException {
        PermutateTarget permutateTarget;
        if (this.permutate_targets_map == null) {
            this.setupPermutateTargetsMap();
        }
        if ((permutateTarget = (PermutateTarget)this.permutate_targets_map.get(html_file_name)) == null) {
            permutateTarget = this.getPermutateTargetTextRegex(html_file_name);
        }
        return permutateTarget;
    }

    private PermutateTarget getPermutateTargetTextRegex(String html_file_name) {
        Iterator permutate_targets_key = this.permutate_targets_map.keySet().iterator();
        while (permutate_targets_key.hasNext()) {
            String now_key = (String)permutate_targets_key.next();
            if (!Pattern.matches(now_key, html_file_name)) continue;
            return (PermutateTarget)this.permutate_targets_map.get(now_key);
        }
        return null;
    }

    private void setupPermutateTargetsMap() throws PermutatePageSourceException {
        if (this.permutate_targets_map == null) {
            this.permutate_targets_map = new HashMap();
            PermutateTarget[] permutate_targets = this.getPermutateTargets();
            int i = 0;
            while (i < permutate_targets.length) {
                this.permutate_targets_map.put(permutate_targets[i].getHtml_file_name(), permutate_targets[i]);
                ++i;
            }
        }
    }

    public String getOld_page_source() {
        return this.old_page_source;
    }

    public void setOld_page_source(String old_page_source, String html_page_name) {
        if (SynapseParameter.isSAVE_SELECT_TEXT_FLAG()) {
            SaveSynapseInfo.savePPSInfo(old_page_source, this.getClass().getName(), html_page_name);
        }
        this.old_page_source = old_page_source;
    }

    public String getPageSource(FormData form_data, SessionData session_data, CookieData cookie_data, ServerInfo server_info) throws PermutatePageSourceException {
        return this.getPageSource(form_data, session_data, cookie_data, server_info, this.old_page_source);
    }

    public abstract String getPageSource(FormData var1, SessionData var2, CookieData var3, ServerInfo var4, String var5) throws PermutatePageSourceException;

    public PermutateTarget[] getPermutateTargets() throws PermutatePageSourceException {
        try {
            return (PermutateTarget[])this.getClass().getField("PERMUTATE_TARGETS").get(this);
        }
        catch (IllegalArgumentException e) {
            throw new PermutatePageSourceException(e);
        }
        catch (SecurityException e) {
            throw new PermutatePageSourceException(e);
        }
        catch (IllegalAccessException e) {
            throw new PermutatePageSourceException(e);
        }
        catch (NoSuchFieldException e) {
            throw new PermutatePageSourceException(e);
        }
    }

    public String toString() {
        return "{" + this.getClass().getName() + "}";
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof PermutatePageSource)) {
            return false;
        }
        PermutatePageSource target_permutate_page_source = (PermutatePageSource)arg0;
        if (!this.old_page_source.equals(target_permutate_page_source.getOld_page_source())) {
            return false;
        }
        Iterator this_permutate_targets_iterator = this.permutate_targets_map.keySet().iterator();
        while (this_permutate_targets_iterator.hasNext()) {
            Object now_this_html_file_name = this_permutate_targets_iterator.next();
            if (!(now_this_html_file_name instanceof String)) {
                return false;
            }
            String now_this_html_file_name_string = (String)now_this_html_file_name;
            try {
                if (this.getPermutateTargetText(now_this_html_file_name_string).equals(target_permutate_page_source.getPermutateTargetText(now_this_html_file_name_string))) continue;
                return false;
            }
            catch (PermutatePageSourceException e) {
                return false;
            }
        }
        return true;
    }
}

