/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.permutate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.famteam.synapse.SynapseParameter;
import org.famteam.synapse.SynapseSetupException;
import org.famteam.synapse.permutate.PPSClassLoader;
import org.famteam.synapse.permutate.PermutatePageSource;
import org.famteam.synapse.permutate.PermutatePageSourceException;
import org.famteam.synapse.permutate.PermutateTarget;

public class PermutatePageSourceManager {
    private static Logger logger_ll = Logger.getLogger((String)"LoadLog");
    private static Map html_loc_and_pps_map;

    public static void setupPermutatePageSource() throws PermutatePageSourceException, SynapseSetupException {
        html_loc_and_pps_map = new HashMap();
        List all_permutate_page_sources = PPSClassLoader.loadPPSClasses(SynapseParameter.getROOT_USER_CLASS_LOCATION());
        Iterator all_pps_iterator = all_permutate_page_sources.iterator();
        while (all_pps_iterator.hasNext()) {
            PermutatePageSourceManager.addPermutatePageSource((PermutatePageSource)all_pps_iterator.next());
        }
        PermutatePageSourceManager.saveLog();
    }

    public static List getPermutatePageSources(String html_source_location) throws PermutatePageSourceException, SynapseSetupException {
        if (html_loc_and_pps_map == null) {
            PermutatePageSourceManager.setupPermutatePageSource();
        }
        Vector return_pps_list = new Vector();
        List full_match_pps = (List)html_loc_and_pps_map.get(html_source_location);
        if (full_match_pps != null) {
            return_pps_list.addAll(full_match_pps);
        }
        return_pps_list.addAll(PermutatePageSourceManager.getPermutatePageSourcesByRegex(html_source_location));
        if (logger_ll.isDebugEnabled()) {
            logger_ll.debug((Object)new StringBuffer("PPSManager log [").append(html_source_location).append("][").append(return_pps_list).append("]."));
        }
        return return_pps_list;
    }

    private static List getPermutatePageSourcesByRegex(String html_source_location) {
        Vector return_pps_list = new Vector();
        Iterator pps_map_keys = html_loc_and_pps_map.keySet().iterator();
        while (pps_map_keys.hasNext()) {
            String now_key = (String)pps_map_keys.next();
            if (html_source_location.equals(now_key) || !Pattern.matches(now_key, html_source_location)) continue;
            List add_pps = (List)html_loc_and_pps_map.get(now_key);
            return_pps_list.addAll(add_pps);
        }
        return return_pps_list;
    }

    private static void addPermutatePageSource(PermutatePageSource permutate_page_source) throws PermutatePageSourceException {
        PermutateTarget[] permutate_targets = permutate_page_source.getPermutateTargets();
        int i = 0;
        while (i < permutate_targets.length) {
            Vector<PermutatePageSource> now_target_ppc_list;
            String now_target_page_location = permutate_targets[i].getHtml_file_name();
            Object now_target_ppc_object = html_loc_and_pps_map.get(now_target_page_location);
            if (now_target_ppc_object == null) {
                now_target_ppc_list = new Vector<PermutatePageSource>();
                html_loc_and_pps_map.put(now_target_page_location, now_target_ppc_list);
            } else {
                now_target_ppc_list = (Vector<PermutatePageSource>)now_target_ppc_object;
            }
            now_target_ppc_list.add(permutate_page_source);
            ++i;
        }
    }

    private static void saveLog() {
        if (logger_ll.isDebugEnabled()) {
            logger_ll.debug((Object)"PPS Load log.\n");
            Iterator pps_key_ite = html_loc_and_pps_map.keySet().iterator();
            while (pps_key_ite.hasNext()) {
                String now_key = (String)pps_key_ite.next();
                logger_ll.debug((Object)now_key);
                Iterator key_pps_ite = ((List)html_loc_and_pps_map.get(now_key)).iterator();
                while (key_pps_ite.hasNext()) {
                    logger_ll.debug((Object)new StringBuffer().append(",").append(key_pps_ite.next().getClass().getName()).append("\n"));
                }
            }
            logger_ll.debug((Object)"\n");
        }
    }
}

