/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#ifndef _MGAttrib_HH_
#define _MGAttrib_HH_

#include <vector>
#include <memory>
#include "mg/Gel.h"
#include "mg/types.h"

//
//Define MGAttrib Class.

class MGIfstream;
class MGOfstream;
class MGAttrib;
class MGGLAttrib;
class MGContext;

/** @addtogroup GelRelated
 *  @{
 */


///MGAttrib is an abstract class that defines attribute elements of MGGel.

///Currently main subclasses of MGAttrib are MGGLAttrib, MGAppearance, and MGContex.
class MG_DLL_DECLR MGAttrib: public MGGel{

public:

////////Special member functions/////////
MGAttrib()=default;
virtual ~MGAttrib()=default;
MGAttrib(const MGAttrib&)=default;///Copy constructor.
MGAttrib& operator=(const MGAttrib&)=default;
MGAttrib(MGAttrib&&)=default;		///Move constructor.
MGAttrib& operator= (MGAttrib&&)=default;///Move assignment.

/// Output virtual function.
virtual std::ostream& out(std::ostream&) const=0;

///Return MGAttrib pointer if this MGGel is an MGAttrib, else return null.
MGAttrib* attrib(){return this;};
const MGAttrib* attrib()const{return this;};

/// Return This object's typeID
///Sub class of MGAttrib must have the id as 0x02nnnnnnL.
virtual long identify_type() const{return MGATTRIB_TID;};

///Test if this gel includes an object.
const MGObject* includes_object()const{return 0;};

///Test if this gel includes an object.
MGObject* includes_object(){return 0;};

protected:

///Read all member data.
virtual void ReadMembers(MGIfstream& buf);

///Write all member data
virtual void WriteMembers(MGOfstream& buf)const;

private:

friend class MGIfstream;
friend class MGOfstream;

};


///Construct a null newed MGAttrib from the type id TID.
MG_DLL_DECLR MGAttrib* MGNullAttrib(long TID);

/** @} */ // end of GelRelated group
#endif
