/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#if !defined(MGINCLUDEGUARD_GELFACTORY__)
#define MGINCLUDEGUARD_GELFACTORY__
#include <map>
#include "mg/MGCL.h"

class MGGel;

/// Factory Method p̃C^[tFCX(MGGelFactoryT̂߂ɒ`j.
struct MGGelFactoryBase
{
	/// TuNXŎ MGGel NX̃IuWFNgԂB
	/// @return MGGel new IuWFNgB
	virtual MGGel* create_gel() const = 0;
};

/// IuWFNgt@Ng[NXpev[gNX.
template <typename T>
struct MGGelFactoryT : public MGGelFactoryBase
{
	/// @return MGGel new IuWFNgB
	virtual T* create_gel() const
	{
		return new T;
	}
};

/// IuWFNgt@Ng[NX.

///
/// Tv
///
/// MGObject* MGNullObj(long TID){
///     MGGelFactoryRegistry* reg = MGGelFactoryRegistry::get_instance();
///     return static_cast<MGObject*>(reg->create_gel(TID));
/// }
class MG_DLL_DECLR MGGelFactoryRegistry
{
public:
	typedef long KeyType;
	typedef std::map<KeyType, MGGelFactoryBase*> TypeMap;

	/// fXgN^[
	/// @post is_valid()  false ԂB
	/// @throws n/a
	~MGGelFactoryRegistry();

	/// VOgANZXB
	/// @return MGGelFactory t@Ng[IuWFNgB
	/// @post is_valid()  true ԂB
	/// @throws n/a
	static MGGelFactoryRegistry* get_instance();

	/// NXIuWFNgLǂԂB
	/// @return bool LȂ΁ifXgN^[Ă΂ĂȂ΁jtrue
	/// @throws n/a
	static bool is_valid();

	/// OIuWFNg쐬B
	/// @param[in] name O
	/// @return MGGel new IuWFNgB
	/// @throws n/a
	/// ݂Ȃ^Cv̏ꍇAkԂB
	MGGel* create_gel(const KeyType& name) const;

	/// t@Ng[IuWFNgo^B
	/// @param[in] name O
	/// @param[in] factory t@Ng[IuWFNg
	/// @pre is_valid()  true ԂB
	void register_factory(
		const KeyType& name,
		MGGelFactoryBase* factory);

	/// t@Ng[IuWFNgo^폜B
	/// @param[in] name O
	/// @pre is_valid()  true ԂB
	/// @throws n/a
	void unregister_factory(const KeyType& name);

	/// t@Ng[IuWFNgo^폜B
	/// @param[in] factory t@Ng[IuWFNg
	/// @pre is_valid()  true ԂB
	/// @throws n/a
	void unregister_factory(MGGelFactoryBase* factory);

private:
	/// RXgN^[
	MGGelFactoryRegistry();

	MGGelFactoryRegistry(const MGGelFactoryRegistry& other);
	MGGelFactoryRegistry& operator=(const MGGelFactoryRegistry& other);

	TypeMap m_map; ///< IuWFNgƃIuWFNgt@Ng[̎B
};


/// t@Ng[WXg[ɃGg[֗NX.

template <typename T>
class MGAutoGelRegister
{
	MGGelFactoryRegistry* m_pRegistry; /// Singleton IuWFNgւ̃|C^[
	MGGelFactoryT<T> m_factory; /// T IuWFNĝ߂̃t@Ng[

public:
	/// RXgN^[
	/// @param[in] name IuWFNg̖O
	MGAutoGelRegister(const MGGelFactoryRegistry::KeyType& name)
		 : m_pRegistry(MGGelFactoryRegistry::get_instance())
	{
		m_pRegistry->register_factory(name, &m_factory);
	}

	/// fXgN^[
	~MGAutoGelRegister()
	{
		if(MGGelFactoryRegistry::is_valid()){
			m_pRegistry->unregister_factory(&m_factory);
		}
	}
};

/// For internal use.
#define GEL_REG_JOIN( s1, s2 ) GEL_REG_JOIN__( s1, s2 )
/// For internal use.
#define GEL_REG_JOIN__( s1, s2 ) s1##s2
/// For internal use.
#define GEL_REG_MAKE_UNIQUE_NAME( prefix ) GEL_REG_JOIN( prefix, __LINE__ )

/// VK MG ̃TuNX`AVACYΏۂƂꍇ́A
/// ̎菇𓥂ށB
///
/// 1. virtual long identify_type() const I[o[ChA
///    K؂ȒlԂ悤B
///    mg/types.h  enum MGGEL_TID ̋Kɏ]ƁB
///
/// 2. TuNX̎t@C (cpp) ɁÅ֐^}NĂяo
///    sLq邱ƁB
///
///    AUTO_GEL_REGISTER(MGMyClass, 0x????????L);
///
///    ŁA0x????????L  MGMyClass::identify_type ƈvlƂ邱ƁB
#define AUTO_GEL_REGISTER(classname, gelname) \
	static MGAutoGelRegister<classname> \
		GEL_REG_MAKE_UNIQUE_NAME( glreg__ ) (gelname);

#endif // defined(MGINCLUDEGUARD_GELFACTORY__)
