/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/*! @mainpage Maestro's Geometry Class Library
 *
 *
 * lfbk B-SplineȐAB-SplineȖʂ܂ދȐAȖʂ舵߂̂b{{
 * NXCułBNURBS܂ޒP̂̋ȐAȖʁAgꂽȖʁAт
 * Winged Edge Data StructureIȍ\ɂ茋VF\܂ł̕\\͂LĂ܂B
 * MGCĹAOtBbNȕ\邽߂ɂ MFC(Microsoft Foundation Class)  OpenGL 4
 * pĂ܂BMFCz̃}}VC^tF[X̃Av쐬邱ƂOƂĂ܂A
 * A̋@\𗘗pȂ̂ł΁Ai̎Kv܂j
 * rĒPȂ郉CuƂĂp\łB
 * 
 * @section MGCL lfbk̃NXA֐͉L̂悤ȃW[ɕނĂ܂
 * (1) Base Class
 * @@lfbk̃x[XƂȂNXQŁAʒuf[^AxN^As񉉎ZA{bNXgA
 *     B-Spline\܂͌\邽߂̊eReiAȂǂSƂȂ܂.
 * 
 * (2) Numerical Analysis
 * @@lfbkŗpĂ鐔lvZ֐ȂǗLpȊ֐܂Ƃ߂Ă܂.
 * 
 * (3) Geometry(sub) classes
 * @@_( MGPoint )Ai MGCurve )A( MGSurface )̊􉽕\̂߂̃NX MGGeometry 
 *     TuNXɂȂ܂.
 * 
 * (4) Topology(sub) classes
 * @@_( MGPVertex , MGBVertex )AGbW( MGEdge )A[v( MGLoop )AgȖ( MGFace )A
 *      VF( MGShell )̈ʑ\\̂߂̃NX MGTopology ̃TuNXɂȂ܂.
 * 
 * (5) GeoRelated classes
 * @@GeometeryNX̓o̓p[^ɗpeNX( MGCoons =Coons Patch,
 *      MGPPRep =\̃XvC, [,Ȃ)ނ܂.
 * 
 * (6) TopoRelated classes
 * @@TopologyNX̓o̓p[^ɗpeNX( MGFOuterCurve , MGLPoint )A
 *      Ȗʂ̃g̃[eBeBNX MGTrimLoop Ȃǂ̃NXނ܂.
 * 
 * (7) Object Related classes
 * @@Geometry, Topologyɋ( MGFSurface )A̕ނɓĂ͂܂ȂNX( MGSTL )A 
 *     MGObject ̃sbN̂߂̏ReiNXނ܂.
 * 
 * (8) Gel Related classes
 * @@MGGel Group Element(Gel)ƂȂ肤NX̒ۃNXŁAׂĂ MGObject ֘A̍ōʂ
 *    ۃNXƂȂ܂BGroup Elementɂ MGObject Group̗vfƂ邱Ƃł܂B
 *    ̕ނɂ́AMGObject MGGel̃NXуO[vGel̈ʒu\
 *    MGGelPosition Ȃǂ̃ReiNXAMGGel ẑׂẴNXނ̂߂
 *    MGAbstractGel, MGAbstractGels Ȃǂނ܂.
 * 
 * (9) File InputOutput classes
 * @@MGGel z̃NX͂܂AMGCL̗pӂt@Co͂̑Ώۂł܂B̓o͂
 *     ߂̃NX MGOfstream , MGIfstream , IGESf[^̓o͂̃NX
 *     ( MGIgesFstream , MGIgesIfstream , MGIgesOstream )ނ܂.
 * 
 * (10) Intersection Container classes
 * @@_( MGPoint )A( MGCurve )A( MGSurface )̊􉽕\mA܂ MGEdge, MGLoop, MGFace, MGShell
 *     Ȃǂ Topology NXƂ̌_Ƃ̔z\܂.
 * 
 * (11) UseTessellation classes
 * @@(MGSurface, MGFace)\邽߂ɂׂ͂ȎOp`ŋߎKv܂B
 *     UseTessellation͋Ȗʂ̎Op`ߎ̂߂̃c[NX񋟂܂B
 *     ̕ނɊ܂܂NX͂̂߂̃NXłAʏ풼ڗpKv͂ȂA
 *     MGShell, MGFSurface(MGFaceMGSurface)shade(), triangulate()𗘗p܂B
 * 
 * (12) Display Handling classes
 * @@MGCLł͐}`̕\OpenGL4, C[Wf[^̎̂߂GDI-plusA}}VC^tF[X
 *     MFC(Micrsoft Foundation Class)𗘗pĂ܂BDisplay Handling Classesɂ͂lfbk
 *     IuWFNg̕\̂߂̃NXƕ\̂߂̃Agr[gȂǂނĂ܂.
 *
 */

//
//  MGCL.h

#ifndef _MGCL_HH_
#define _MGCL_HH_

#include "MGCLDefs.h"

/** @file */
/** @defgroup BASE Base Class
 *  @{
 */

extern MG_DLL_DECLR const char* _MGCL_VER;
extern MG_DLL_DECLR const char* _MGCL_FILE;
// Maestro's Geometry Classes Library version 5.30
// <<<<<<<<<<4/20/2001>>>>>>>>>>>> //
// Ƃ4.10̏ꍇ MGCL0410ɂȂB

///   l̐ݒ
const double mgPAI = 3.1415926535897932384626433833;

/// @var mgHALFPAI
/// @brief /2 l̐ݒ
const double mgHALFPAI = mgPAI/2.;

/// 2.0 *  l̐ݒ
const double mgDBLPAI = mgPAI*2.;

///
///Infinite value Definition. This value is used in MGEReal class
///to identify infinite value of double.
///
const double mgInfiniteVal = 1.e+20;

///Infinite type.
enum MGINFINITE_TYPE {
     MGINFINITE_MINUS=-1,      ///< Minus infinite
	 MGINFINITE_FINITE=0,      ///< Finite
     MGINFINITE_PLUS=1,		   ///< Plus infinite
};

///MGInterval type.
enum MGINTERVAL_TYPE {
     MGINTERVAL_EMPTY,          ///<Empty interval. Interval ͋W
     MGINTERVAL_FINITE,         ///<Finite interval(above and below)
								///<AƂL
     MGINTERVAL_FINITE_ABOVE,   ///<Finite above and infinite below.
								///<LA
     MGINTERVAL_FINITE_BELOW,   ///<Finite below and infinite above.
								///<AL
     MGINTERVAL_INFINITE        ///<Infinite below and above.
								///<AƂɖ 
};

///Relation type of plane and stright line.
///(Plane vs Plane, Plane vs S.Line, S.Line vs S.Line)
enum MGPSRELATION {
     MGPSREL_UNKNOWN,           ///<Unknown. s
     MGPSREL_TORSION,           ///<Torsion. ˂
     MGPSREL_ISECT,				///<Intersection. 
     MGPSREL_PARALLEL,          ///<Parallel. s
     MGPSREL_COIN,              ///<Coincidence. 
     MGPSREL_VIRTUAL_ISECT      ///<Virtually intersection
								///<(Intersection at extended line).
								///<w蒼̉̓_ł̌
};

///Curve type(Ȑ̎).
enum MGCURVE_TYPE {
	MGCURVE_UNKNOWN,		///<Unkown. s
	MGCURVE_STRAIGHT,		///<MGStraight(Straight line). 
	MGCURVE_ELLIPSE,		///<MGEllipse(Ellipse). ȉ~
	MGCURVE_SPLINE,			///<B-Spline(MGLBRep). XvC
	MGCURVE_RSPLINE,		///<B-Spline(MGRLBRep)
	MGCURVE_SURFACE,		///<MGSurfCurve(Parameter line of a surface)
	MGCURVE_TRIMMED,		///<MGTrimmedCurve(Trimmed curve)
	MGCURVE_COMPOSITE,		///<MGCompositeCurve(Composite Curve)
	MGCURVE_USER1,			///<Auxiliary curve type 1
	MGCURVE_USER2,			///<Auxiliary curve type 2
	MGCURVE_BSUM			///<Boolean sum curve
};

///Ellipse type(ȉ~̎).
enum MGELLIPSE_TYPE {
	 MGELLIPSE_EMPTY		///<Empty ellipse. 
	,MGELLIPSE_SEGMENT		///<Segment ellipse. ZOg
	,MGELLIPSE_CLOSED		///<Closed(Whole) ellipse.ȉ~
};

///Straight line type(̎).
enum MGSTRAIGHT_TYPE {
	 MGSTRAIGHT_EMPTY 		///<Empty. 
	,MGSTRAIGHT_SEGMENT		///<Line segment. 
	,MGSTRAIGHT_HALF_LIMIT	///<Half unlimit. 
	,MGSTRAIGHT_UNLIMIT		///<Unlimit line for both direction. 
};

///Surface type(Ȗʂ̎).
enum MGSURFACE_TYPE {
	MGSURFACE_UNKNOWN,		///<Unknown. s
	MGSURFACE_PLANE,		///<Plane. 
	MGSURFACE_CONE,			///<Cone. ~
	MGSURFACE_SPHERE,		///<Sphere. 
	MGSURFACE_TORUS,		///<Torus. ~
	MGSURFACE_SPLINE,		///<Free form surface
							///<(Tensor product surface of LBRep) RȖ
	MGSURFACE_RSPLINE,		///<Free form surface
							///<(Rational B-Spline Surface)
	MGSURFACE_CYLINDER,		///<Cylinder surface(A special case of MGSURFACE_CONE)
	MGSURFACE_USER1,		///<Auxiliary surface type 1
	MGSURFACE_USER2,		///<Auxiliary surface type 2
	MGSURFACE_BSUM			///<Boolean sum surface
};

///Relation of curve and curve(ȐƋȐ̌_̊֌W).
enum MGCCRELATION {
	MGCCREL_UNKNOWN,	///<Unknown.
						///<miׂĂȂāA킩ȂAȉ̂ꂩj
	MGCCREL_ISECT,		///<Intersection. iAڂAvȊOj
	MGCCREL_NORMAL,		///<Intersection at right angle. 
	MGCCREL_TANGENT,	///<Two curves are tangent. ڂ
	MGCCREL_COIN		///<Two curves are coincident. v
};

///Relation of curve and surface(ȐƋȖʂ̌_̊֌W).
enum MGCSRELATION {
	MGCSREL_UNKNOWN,///<Unknown. m
	MGCSREL_IN,		///<Intersection from inner of surface. Ȗʂ̓̌_
	MGCSREL_OUT,	///<ntersection from outer of surface. Ȗʂ̊Ǒ_
	MGCSREL_IN_TAN,	///<Tangent from inner of surface.Ȗʂ̓ڂĂ
	MGCSREL_OUT_TAN,///<Tangent from outer of surface.Ȗʂ̊OڂĂ
	MGCSREL_COIN	///<Curve is included in surface. ȐȖʂɊ܂܂Ă
};

///Relation of Surface and Surface(SurfaceSurfacě̊֌W).
enum MGSSRELATION {
	MGSSREL_UNKNOWN,	///<Unknown.
						///<miׂĂȂāA킩ȂAȉ̂ꂩj
	MGSSREL_ISECT,		///<Intersection. iڂAvȊOj
	MGSSREL_TANGENT,	///<Tangent. ڂ
	MGSSREL_COIN		///<Coincident. v
};

///End condition to get spline by interpolation.
enum MGENDCOND {
	MGENDC_UNKNOWN=0,	///< Unknown(usually not used).m
	MGENDC_1D  =1,		///< 1st deravative provided.
	MGENDC_2D  =2,		///< 2nd deravative provided.
	MGENDC_NO  =3,		///< no end cond(only positional data)
	MGENDC_12D =4		///< both 1st and 2nd deravatives provided.
};

///a set of triangl type(Rp`_Xg̃^Cv).
enum mgTESTRIANG {
	mgTESTRIANG_UNKNOWN,	///<Unknown
	mgTESTRIANG_FAN,		///<like a csTriFanSet
	mgTESTRIANG_STRIP		///<like a csTriStripSet
};

///Debug function. fobO֐
MG_DLL_DECLR std::ostream& operator<< (std::ostream& out, MGINTERVAL_TYPE rel);
MG_DLL_DECLR std::ostream& operator<< (std::ostream& out, MGPSRELATION rel);
MG_DLL_DECLR std::ostream& operator<< (std::ostream& out, MGCURVE_TYPE rel);
MG_DLL_DECLR std::ostream& operator<< (std::ostream& out, MGELLIPSE_TYPE rel);
MG_DLL_DECLR std::ostream& operator<< (std::ostream& out, MGSTRAIGHT_TYPE rel);
MG_DLL_DECLR std::ostream& operator<< (std::ostream& out, MGSURFACE_TYPE rel);
MG_DLL_DECLR std::ostream& operator<< (std::ostream& out, MGCCRELATION rel);
MG_DLL_DECLR std::ostream& operator<< (std::ostream& out, MGCSRELATION rel);
MG_DLL_DECLR std::ostream& operator<< (std::ostream& out, MGSSRELATION rel);
MG_DLL_DECLR std::ostream& operator<< (std::ostream& out, MGENDCOND rel);

///Function's return value is angle in radian, from zero to 2PAI.
extern MG_DLL_DECLR double MGAngle(
	double ca,	///<cosine value
	double sa);	///<sine value

///MGCL namespace defines varialbes without prefix mg or MG.
///From historical reasons, varialbes with prefix mg or MG are not included in MGCL namespace.
namespace MGCL{

///Tessellation parameter to select fan kind for the tessellation.
enum fan_kind{
	SINGLE_TRIANGLE, ///< 1 triangle/FAN(default) and STRIP for as many as posible triangles,
		///<STRIP triangles may cover multiple rectangles.

	MULTIPLE_TRIANGLES, ///< as many triangles as possible/FAN and STRIP for as many as posible triangles,
		///<STRIP triangles may cover multiple rectangles.

	SINGLE_TRIANGLE_NO_STRIP,///<SINGLE_TRIANGLE, but STRIP triangles cover only one tessellated rectagle.
	MULTIPLE_TRIANGLES_NO_STRIP,///<MULTIPLE_TRIANGLES, but STRIP triangles cover only one tessellated rectagle.
};

///Surface curvature evaluation parameter.
enum SURFACE_CURVATURE_KIND{
	GAUSSIAN_CURVATURE = 0,///< Gaussian curvature
	MEAN_CURVATURE = 1,  ///< mean curvature
	MINIMUM_CURVATURE = 2,///< minimum curvature
	MAXIMUM_CURVATURE = 3 ///< maximum curvature
};

///Display mode of MGObject.
///SHADING and WIRE_AND_SHADING are valid only for MGObject of manifold dimension 2.
enum VIEWMODE{
	DONTCARE=0,
	WIRE=1,		///< wire frame mode
	SHADING=2,	///< surface mode
	WIRE_AND_SHADING=3, ///< wire and surface mode
	HIGHLIGHT=4
};

///Triangles' data kind.
enum TL_DATA_KIND{
	UV=0,///< data included are surface parameter (u,v).
	XYZ,///< data included are surface world coordinate (x,y,z).
	XYZNormal///< data included are surface world coordinate and the normal vectors,
		///<(x,y,z,Nx,Ny,Nz).
};

///Get the MGCL_Version number.
extern MG_DLL_DECLR const char* Version();

///Get the MGCL File validity.
extern MG_DLL_DECLR const char* File_validity();

///Compute the difference of min and max of the three doubles a1, a2, and a3.
double MG_DLL_DECLR Max3(double a1, double a2, double a3);

///convert the angle unit from degree to radian.
inline double degree_to_radian(double degree){
	const double coef = mgPAI / 180.;
	return degree * coef;
}

///convert the angle unit from radian to degree.
inline double radian_to_degree(double radian){
	const double coef = 180. / mgPAI;
	return radian * coef;
}

///킹AftHgł͏ォ4cA͐؂̂Ă.
double MG_DLL_DECLR decimalAlign(double dValue, int nDigit = 4);

///Round the input angel degree value degree to the multiples of step.
///The input degree and step are assumed to be angle in degree.
///step must be greater than 1.
///degree must be greater or equal to 0. and less than 360.
///Returned is a positibe value.
double MG_DLL_DECLR round_angle(double degree, double step);

///Start up the MGCL.

///This is necessary only when MGIgesxxxx class or MGImage or MGTexturexxxxx class is
///to use. Before use of GDIplus, GdiStartUp is necessary, this start_up will do it.
void MG_DLL_DECLR start_up(
	bool need_to_GdiStartUp=false	///<True if GdiplusStartUp is necessary.
);

///Read in integer_string into intData.
///Function's return value is
///  true: when value specified.
///  false:when value not specified, intData be 0.
MG_DLL_DECLR bool get_integer(
	char pDelimeter,	///<parameter delimeter
	std::istringstream& istrm,	///<Input string stream that contains integer data.
		///<The stream pointer will be advanced to the start position of the next item.
	int& intData	///<output integer data that is converted from the istrm data.
);

///Read in integer_string into intData.
///Function's return value is
///  true: when value specified.
///  false:when value not specified, intData be 0.
MG_DLL_DECLR bool  get_integer(
	char pDelimeter,	///<parameter delimeter
	std::istringstream& istrm,	///<Input string stream that contains integer data.
		///<The stream pointer will be advanced to the start position of the next item.
	short& shortData	///<output integer data that is converted from the istrm data.
);

///Read in real_string into realData
///Function's return value is
///  true: when value specified.
///  false:when value not specified, realData be 0.
MG_DLL_DECLR bool get_real(
	char pDelimeter,	///<parameter delimeter
	std::istringstream& istrm,	///<Input string stream that contains real data.
		///<The stream pointer will be advanced to the start position of the next item.
	double& realData	///<converted real data from istrm will be output.
);

///Read in real_string into realData
///Function's return value is
///  true: when value specified.
///  false:when value not specified, realData be 0.
MG_DLL_DECLR bool get_real(
	char pDelimeter,	///<parameter delimeter
	std::istringstream& istrm,	///<Input string stream that contains real data.
		///<The stream pointer will be advanced to the start position of the next item.
	float& floatData	///<converted real data from istrm will be output.
);

///Shut down the MGCL.
void MG_DLL_DECLR shut_down();

///@cond
static ULONG_PTR m_gdiplusToken;///<a token to pass GdiplusShutdown.
							///<Initialized at GdiplusStartup.

static bool m_gdiplus_initialized;///<Indicates if MGCL startup Gdiplus.
///@endcond
};


/** @} */ // end of BASE group
#endif
