/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#ifndef _MGStl_HH_
#define _MGStl_HH_

#include <map>
#include "mg/drawParam.h"
#include "mg/object.h"
#include "mg/Curve.h"
#include "mg/Surface.h"
#include "mg/FSurface.h"
#include "topo/Face.h"
#include "topo/Shell.h"

class mgTL2Triangles;
class mgVBO;

/** @addtogroup MGObjectRelated
 *  @{
 */

//Define MGStl Class.

///MGStl is a concrete class which represents an STL information.

///̃NX͕̎Op`zƂĕێ.
///SĂ̎Op`̒_̍W̓t@Cǂݍ񂾏ŁAd菜ĔzɊi[.
///m_indicesɂ̓t@Cǂݍ񂾏ԂŊeOp`̒_̕тi[Ă
///̊evfɂ͊Y钸_W̔z̓Yi[.
///Ⴆ΁AiԖڂ̎Op`̊e_̍W̓Yindices[i*3]Aindices[i*3+1]Aindices[i*3+2]
///Ƃȏ̏Ŋi[Ă.
class MG_DLL_DECLR MGStl : public MGObject{

/// mapɂ1̃L[ɑ΂ĕ̒l͎߂Ȃ
/// Op`\钸_ID߂\̂𗘗p
class vertId{
public:
	int id1;
	int id2;
	int id3;
};

/// ֐IuWFNgi[\
class positionComp{
public:
	bool operator()(const MGPosition& p1, const MGPosition& p2) const{
		/// lexicographical_compare style
		if(p1(0) < p2(0)){
			return true;
		}else if(p2(0) < p1(0)){
			return false;
		}
		if(p1(1) < p2(1)){
			return true;
		}else if(p2(1) < p1(1)){
			return false;
		}
		if(p1(2) < p2(2)){
			return true;
		}else if(p2(2) < p1(2)){
			return false;
		}
		/// p1 == p2
		return false;
	}		
};

/// Op`̒_̍WA_̔ԍi[map̕ʖ`.
typedef std::map<MGPosition, int, positionComp> triangleMap;

/// _̃CfbNXA_̍Wi[map̕ʖ`.
typedef std::map<int, MGPosition> IndexPosMap;

/// Op`̃CfbNXA3̒_̃CfbNXi[map̕ʖ`.
typedef std::map<int, vertId> TriVertMap;

public:

////////Special member functions/////////
MGStl()=default;
~MGStl()=default;
MGStl(const MGStl&)=default;///Copy constructor.
MGStl& operator= (const MGStl&)=default;///Copy assignment.
MGStl(MGStl&&)=default;		///Move constructor.
MGStl& operator= (MGStl&&)=default;///Move assignment.


///conversion constructor from tessellation data.
MGStl(
	const mgTL2Triangles& tris///<mgTL2Triangles whose data depend on tris.get_kind();
);
MGStl(
	double error,	///<Error to regard two points are the same.
	const mgTL2Triangles& tris///<mgTL2Triangles whose data depend on tris.get_kind();
);

///conversion constructor from tessellation data.
MGStl(const std::vector<mgTL2Triangles>& tlDataVector);

///Constructor from triangle data, index+vertices.
///This constructor uses the wc_zero to identify
///different two positions as the same input position.
MGStl(
	int nTriang, ///< Op`̐
	const int* triang,///< _id. The id's start from 1.
		///<(i*3, i*3+1, i*3+2) for i=0,...,indices.size()/3.
	const double* verts ///< _̍W. verts[id0], [id1], [id2] make
		///< a triangle for id0=triang[i*3], id1=triang[i*3+1], id2=triang[i*3+2]
		///<  for i=0,...,nTriang.
);

///Constructor from triangle data, index+vertices.
///This constructor uses the wc_zero to identify
///different two positions as the same input position.
MGStl(
	const std::vector<MGPosition>& vertices,///< vertices[id0], [id1], [id2] make
		///<a triangle for id0=indices[i*3], id1=indices[i*3+1], id2=indices[i*3+2]
		///<for i=0,...,indices.size()/3.
	const std::vector<int>& indices ///< _id. The id's start from 1.
		///<  (0,1,2),...(i*3, i*3+1, i*3+2) for i=0,...,indices.size()/3.
);

/// SĂ̒_ƃ{bNX̍WɎw肵MGVector̒lZ.
MGStl& operator+=(const MGVector& v);

/// SĂ̒_ƃ{bNX̍Ww肵MGVector̒l.
MGStl& operator-=(const MGVector& v);

/// SĂ̒_ƃ{bNX̍WɎw肵l|.
MGStl& operator*=(double scale);

/// ^ꂽϊs.
MGStl& operator*=(const MGMatrix& mat);

/// ^ꂽϊɂgXtH[s.
MGStl& operator*=(const MGTransf& tr);

/// 2MGStlIuWFNg肷.
bool operator==(const MGStl& stl);

std::ostream& out(std::ostream& ostrm)const;

/// STLt@C̐}`bounding box擾.
/// ߂lFSTLt@C̐}`bounding box
const MGBox& box()const;

///Construct new object by copying to newed area.
///User must delete this copied object by "delete".
MGStl* clone()const;

/// Return This object's typeID.
long identify_type()const;

///Draw 3D curve in world coordinates.
///The object is converted to curve(s) and is drawn.
void drawWire(
	mgVBO& vbo,///<The target graphic object.
	int line_density=1	///<line density to draw a surface in wire mode.
)const;

///Draw 3D point(vertex) in world coordinates.
///The object is converted to point(s) and is drawn.
///This is valid only for topology objects or MGPoint.
void draw3DVertex(
	mgVBO& vbo///<The target graphic object.
)const;

///Shade the object in world coordinates.
void shade(
	mgVBO& vbo,///<The target graphic object.
	const MGDrawParam& para,///<Parameters to draw.
	mgVBO::ELEMENT_TARGET target=mgVBO::SHADING///<The target vbo element.
)const;

///@cond
///Compute the intersections of two objects.
///***********MGStl does not support the intersection functions.******
MGisects intersection(const MGObject& obj2)const{return MGisects(this,&obj2);};
MGisects intersection(const MGCurve& obj2)const{return MGisects(this,&obj2);};
MGisects intersection(const MGFSurface& obj2)const{return MGisects(this,obj2.object_pointer());};
MGisects intersection(const MGSurface& obj2)const{return MGisects(this,&obj2);};
MGisects intersection(const MGFace& obj2)const{return MGisects(this,&obj2);};
MGisects intersection(const MGShell& obj2)const{return MGisects(this,&obj2);};
///@endcond

///Get manifold dimension.
int manifold_dimension()const{return 2;};

///Write all member data.
void WriteMembers(MGOfstream& buf)const;

///Read all member data.
void ReadMembers(MGIfstream& buf);

///return the ref to m_vecPos.
const std::vector<MGPosition>& positions()const{return m_vecPos;};
std::vector<MGPosition>& positions(){return m_vecPos;};

///return the ref to m_vecPos.
const std::vector<MGUnit_vector>& normals()const{return m_vecNormlTriang;};
std::vector<MGUnit_vector>& normals(){return m_vecNormlTriang;};

/// Op`̌擾.
/// ߂lFOp`̌.
int GetTriangleCount()const{return int(m_vecNormlTriang.size());};

/// w肵Op`̒_WĂz̃CfbNX擾.
void GetVertIndices(
	int i, ///< [in]FOp`̃CfbNX(0 <= i < GetTriangleCount)
	int pos[3] ///< [out]Fw肵Op`̊e_W̔z̓Y[i, j, k]
)const;

/// Ŏw肵pXSTLt@Cǂݍ݃oɒlݒ肷.

/// ܂MGTolerance::wc_zeroɒlݒ肷.
/// ߂l: =0t@C̓ǂݍ
///		  !=0 ǂݍ܂ȂB܂͎s(std::ifstream̃G[R[hj
/// :m_vecPos, m_vecNorml, m_indices, m_boxɐ}`̏񂪊i[.
///			MGTolerance::wc_zeroɒlݒ肳.
int LoadFile(
	const TCHAR* strFilePath ///< [in]:ǂݍSTLt@Cւ̃pX
);

/// w肳ꂽpXAscii`STLt@Cۑ.

/// ߂l: =0t@C݂̏
///		  !=0 ܂ȂB܂͎s(std::ofstream̃G[R[h)
/// :rSTLFilePathɎw肵pXAscii`STLt@Cۑ.
int SaveAscii(
	std::ofstream& fout
)const;

/// w肳ꂽpXBinary`STLt@Cۑ.

/// ߂l: =0t@C݂̏
///		  !=0 ܂ȂB܂͎s(std::ofstream̃G[R[h)
/// :rSTLFilePathɎw肵pXBinary`STLt@Cۑ.
///dlύXFɃXg[n悤ɕύX09/09/17.
int SaveBinary(
	const TCHAR* rSTLFilePath ///< [in]:t@C̕ۑ̃pX
)const;

/// 3_쐬Op`̏oϐɒlݒ肷

/// O:͂pos1, pos2, pos3͔vɂȂĂ邱
/// :m_vecPos, m_vecNormlTriang, m_indicesɎOp`̏񂪐ݒ肳
/// ܂A͂ꂽ3_ʂ̖@߁Am_vecNormlTriangpush_back
/// ɁAw肵_̍WɕۑĂ邩
/// ۑĂꍇ́AY钸_̃CfbNX󂯎
/// m_indicespush_back
/// ۑĂȂꍇ́A_m_vecPospush_back
/// ɃCfbNX+1A󂯎m_indicespush_back
void push_back_triangle(
	const MGPosition& pos1,
	const MGPosition& pos2,
	const MGPosition& pos3,
	triangleMap& VertexMap
);

/// Op`Ƃɖ@\.
void display_arrows(mgSysGL& sgl)const;

/// o[f[^𒼐ڃZbg.
void set_all_data(
	const std::vector<MGPosition>& vertices,
	const std::vector<int>& indices);

/// Update the bounds.
void update_bounds();

/// Update the all normals of the triangles.
void update_normals();

///Get the name of the class.
std::string whoami()const{return "Stl";};

/// ǂݍstlf[^objtH[}bgɕϊAo͂
/// ߂l: =0 t@C݂̏
///        !=0 ܂ȂB܂͎s(std::ofstream̃G[R[h)
/// :w肵pXobjt@Cۑ.
int SaveObjFormatFromStl(std::ofstream& fout)const;

private:

/// xt@Cǂ݁Aoɒlݒ肳ꂽԂōĂуt@Cǂނ.
/// o̒l㏑B邽߁Ao̒lSăZbg.
void Initialize();

/// Ascii`̃t@CǂݍݑSĂ̍Wl擾.
/// ܂}`̃{bNXgݒ肷.
/// ߂l: =0t@C̓ǂݍ
///		  !=0 ǂݍ݂Ɏs(std::ifstream̃G[R[h)
/// O:ɃI[vꂽt@CXg[n.
/// :vecPosɑSĂ̍Wli[A boxɃ{bNXg̍Wlݒ肳.
/// t@CXg[i.
int LoadAscii(
	std::ifstream& in, ///< [in/out]:ɃI[vꂽt@CXg[ .
	std::vector<MGPosition>& vecPos ///<[out]:t@Cǂݍ񂾍Wl̔z.
	);

/// Binary`̃t@CǂݍݑSĂ̍Wl擾.
/// ܂}`̃{bNXgݒ肷.
/// ߂l: =0t@C̓ǂݍ
///		  !=0 ǂݍ݂Ɏs(std::ifstream̃G[R[h)
/// O:ɃI[vꂽt@CXg[n.
/// :vecPosɑSĂ̍Wli[A m_boxɃ{bNXg̍Wlݒ肳.
///			t@CXg[i
int LoadBinary(
	std::ifstream& in, ///< [in/out]:ɃI[vꂽt@CXg[.
	std::vector<MGPosition>& vecPos ///<[out]:t@Cǂݍ񂾍Wl̔z.
	);

/// t@Cǂݍ񂾑SĂ̒_̍Wli[Ă.
/// vecPoseOp`̖@vZAm_vecNormlTriangɒǉ.
/// vecPos̊evf̍Wl̏dgXɔf
/// d菜Am_vecPosɒǉ.
/// vecPos̊evf̃CfbNXm_indicesɒǉ.
/// :m_vecNormlTriang, m_indicesɒlݒ肳.
void set_mesh_data(
	const std::vector<MGPosition>& vecPos ///< [in]:t@Cǂݍ񂾍Wl̔z.
);

/// ͂łpositionVertexMapɂłɓo^Ă邩`FbN.
/// o^Ă΂m_vecPosYԂ,
/// o^̏ꍇAVm_vecPosɊi[Apositionm_vecPosYmapVertexMap
/// o^.
int IdentifyPosition(
	const MGPosition& position, ///< [in]:_̍W.
	triangleMap& VertexMap ///< [in/out]:_̍WA_̃CfbNXێ.
);

///mgTL2TrianglesMGStlɒǉ
void AddTL2Data(
	const mgTL2Triangles& tris,///<mgTL2Triangles whose data depend on tris.get_kind();
	triangleMap& VertexMap
);

///mgTL2TrianglesMGStlɒǉ
void AddTL2Data(
	double error,	///<Error to regard two points are the same.
	const mgTL2Triangles& tris,///<mgTL2Triangles whose data depend on tris.get_kind();
	triangleMap& VertexMap
);

/// STLt@C̐}`bounding boxi[.
mutable MGBox m_box;

/// STLt@C̐}`\eOp`́AW̏dȂ_W̔z.
/// t@Cǂݍ񂾏ŁAW̏d菜AWli[Ă.
std::vector<MGPosition> m_vecPos;

/// STLt@C̐}`\eOp`̖@xNg̔z.
/// t@Cǂݍ܂ꂽŎOp`̖@xNgi[Ă.
///m_vecNormlTriang.size()*3=m_indices.size().
///m_vecNormlTriang[i] is the normal of the triangle  m_indices[i], [i+1], [i+2] for
///i=0, ..., m_indices.size()/3.
std::vector<MGUnit_vector> m_vecNormlTriang;

/// STLt@C̐}`\eOp`̊e_ɑΉ
/// W̔z̃CfbNXi[z.
/// t@Cǂݍ񂾏ԂŊeOp`̒_̕тi[Ă.
/// evfɂ͊Y钸_W̔z̓Yi[Ă.
/// FiԖڂ̎Op`̊e_̍W̔z̓Y
/// m_indices[i*3]A[i*3+1]A[i*3+2]Ƃȏ̏Ŏ擾ł.
std::vector<int> m_indices;

};

/** @} */ // end of MGObjectRelated group

#endif
