/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#if !defined(_MGVBOPOINTER__INCLUDED_)
#define _MGVBOPOINTER__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "StdAfx.h"
#include "mg/drawParam.h"
#include "mgGL/Color.h"
#include "mgGL/GLAttrib.h"
#include "mgGL/VBO.h"
#include "mgGL/VBOLeaf.h"

class MGPosition;
class MGBox;
class MGBPointSeq;
class MGSPointSeq;
class MGCurve;
class MGSPointSeq;
class mgTL2Triangles;
class MGStl;
class MGColor;
class MGAttribedGel;
class MGComplex;
class MGCellBase;
class mgVBOLeafBuilder;
class mgVBOLeaf;
class mgTexture;

/** @file */
/** @addtogroup DisplayHandling
 *  @{
 */

/////////////////////////////////////////////////////////////////////////////
// mgVBOPointer

///MGGroupȂǂmemberMGGel̕`mgVBOelementƂ邽߂̃NX.

///MGAttribedGelɑ΂`MGAttribedGelunique_ptr<mgVBO>ƂĕێB
///pointerΏۂƂmgVBOPointer쐬mgVBÕo[ƂB
///mgVBOPointervboQƂ̂݁B
class MG_DLL_DECLR mgVBOPointer:public mgVBOElement{
public:

///MGAttribedGelpconstructor.
///mgVBOPointervboQƂ̂
mgVBOPointer(mgVBO& vbo):m_vbo(&vbo){;};

~mgVBOPointer(){;};

//mgVBOPointer* clone()const;

///mgVBOElementnull(܂draw/make_display_list()ĂȂj𔻒
///mgVBOPointerm_vboɑ΂make_display_list()ȂĂȂƂfalseԂ
bool is_made(MGCL::VIEWMODE viewMode=MGCL::DONTCARE){return m_vbo->is_made(viewMode);};


///łɍ쐬ς݂łĂIɍč쐬sB
void make_display_list(MGCL::VIEWMODE vmode=MGCL::DONTCARE){
	m_vbo->make_display_list(vmode);
};

///`֐draw()́Ais_made()==falseł΁A쐬A\B
///is_made()(`f[^쐬ς݁jł΁Ałɍ쐬ꂽmgVBOElement̕`sB
void draw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE);

///draw()mgVBOLeaf쐬ς݁inot null)ł΍쐬sȂA
///redraw()͋Iɍč쐬s`揈ȂB
void redraw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE){m_vbo->redraw(viewMode);};
	
///`֐selectionDraw()́AObjectÎ߂̕\B
///ʏdrawƂ̑F///ColorƂm_bufferIDpAsizeȊO
///attributes̏inormal, texture, color)ȂB
virtual void selectionDraw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE);

///Obtain display list name.
///0(null) ͂mgVBOElementmgVBOLeafłAOȂƂB
///OmgVBO
unsigned getDName()const{return 0;};

///Selectionɐݒ肷閼O߂B=0̂ƂAO̐ݒ菈ȂB
///0(null) ͂mgVBOElementmgVBOLeafłAOȂƂB
///OmgVBO
virtual GLuint getSelectionName()const{return m_vbo->getSelectionName();};

mgVBO* vboPointer(){return m_vbo;};

protected:

private:
	///mgVBOPointervboQƂ̂
	mgVBO* m_vbo;
};

/////////////////////////////////////////////////////////////////////////////
// mgVBOLeafPointer

///łɍ쐬ς݂mgVBOLeafVBÕo[ielementjƂĕێ邽߂̃NX.

///ȂǁAmgVBOLeafłɍ쐬ς݂̂̂VBÕo[ielementjƂĕ`悷邽߂̃NX.
///mgVBOLeafpointerΏۂƂmgVBOLeafPointer쐬mgVBÕo[ƂB
///mgVBOLeafPointermgVBOLeafQƂ̂݁Binstance͗p҂̊ǗƂȂB
class MG_DLL_DECLR mgVBOLeafPointer:public mgVBOElement{
public:

///MGAttribedGelpconstructor.
///mgVBOLeafPointervboQƂ̂
mgVBOLeafPointer(const mgVBOLeaf& leaf);

~mgVBOLeafPointer(){;};

//mgVBOLeafPointer* clone()const;

///mgVBOElementnull(܂draw/make_display_list()ĂȂj𔻒
///mgVBOLeafPointer͏trueԂ
bool is_made(MGCL::VIEWMODE viewMode=MGCL::DONTCARE){return true;};

///łɍ쐬ς݂łĂIɍč쐬sB
///mgVBOLeafPointer͂ȂɂȂB̐ɊւĂ͗p҂̐ӔCƂȂ
void make_display_list(MGCL::VIEWMODE vmode=MGCL::DONTCARE){;};

///`֐draw()́Ais_made()==falseł΁A쐬A\B
///is_made()(`f[^쐬ς݁jł΁Ałɍ쐬ꂽmgVBOElement̕`sB
void draw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE);

///draw()mgVBOLeaf쐬ς݁inot null)ł΍쐬sȂA
///redraw()͋Iɍč쐬s`揈ȂB
///mgVBOLeafPointerłdrawƓB̐ɊւĂ͗p҂̐ӔCƂȂ
void redraw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE){draw(viewMode);};
	
///`֐selectionDraw()́AObjectÎ߂̕\B
///ʏdrawƂ̑F///ColorƂm_bufferIDpAsizeȊO
///attributes̏inormal, texture, color)ȂB
void selectionDraw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE);

///Obtain display list name.
///0(null) ͂mgVBOElementmgVBOLeafłAOȂƂB
///OmgVBO
unsigned getDName()const{return 0;};

///Selectionɐݒ肷閼O߂B=0̂ƂAO̐ݒ菈ȂB
///0(null) ͂mgVBOElementmgVBOLeafłAOȂƂB
///OmgVBO
GLuint getSelectionName()const{return 0;};

const mgVBOLeaf* leafPointer()const{return m_VBOLeaf;};
mgVBOLeaf* leafPointer(){return m_VBOLeaf;};

protected:

private:
	///mgVBOLeafPointervboQƂ̂
	mgVBOLeaf* m_VBOLeaf;
};

/** @} */ // end of DisplayHandling group
#endif // !defined(_MGVBOPOINTER__INCLUDED_)
