#ifndef _MGGLSLPROGRAM_H
#define _MGGLSLPROGRAM_H


#include <string>
#include <glm/glm.hpp>
#include <iostream>
#include "mg/MGCL.h"
#include "mg/Position.h"

class mgStaticGLAttrib;
class MGColor;
class mgGLSLProgram;

/** @file */

/** @addtogroup DisplayHandling
 *  @{
 */

///mgGLSL is a namespace for OpenGL handling, maily used by mgGLSLProgram.
namespace mgGLSL{

/// function ID
/// `^Cv(FuncTypestandard̂Ƃ̂ݗL)
/// Primitive:ʏ̃v~eBu
/// Texture:eNX``
/// gridTexture:_̃XvCg`
typedef enum {
	Primitive = 0,
	Texture = 11,
	gridTexture=12,
} DrawType;

/// `^Cv
/// standard:ʏ`
/// Select:Selectp`
/// Analysis:͕\p`
typedef enum {
	standard=0,
	Select = 1,
	Analysis = 5,
} FuncType;

/// Wϊ^Cv(Vertex̍Wn)
/// World:[hWn
/// NdcScreen:NDCԍWn
/// AnchorPoint:AJ[|Cg̑΋(AJ[|Cg̓[hWnŎw)
/// AnchorPointScreen:AJ[|Cg̑΋(AJ[|CgNDCWnŎw)
typedef enum {
	World = 0,
	NdcScreen=2,
	AnchorPoint = 3,
	AnchorPointScreen = 4,
}CoordinateType;

/// ƌ
/// NoShading:ƌȂ
/// Shading:ƌ
typedef enum {
	NoShading=0,
	Shading=1,
} ShadeMode;

/// [u^Cv
/// ZebraVert:
/// ZebraHorizon:
typedef enum {
	ZebraVert = 0,
	ZebraHorizon = 1,
}ZebraType;

///change error code to string and print it.
MG_DLL_DECLR void printOpenGLError(int errorCode);

/// Returns 1 if an OpenGL error occurred, 0 otherwise.
MG_DLL_DECLR int checkForOpenGLError(const char*, int);

/// Dump OpenGL version info.
MG_DLL_DECLR void dumpGLInfo(bool dumpExtensions = false);

/// get LightEnable (Shade On/Off) data.
MG_DLL_DECLR bool LightEnabled();

MG_DLL_DECLR void CALLBACK debugCallback(GLenum source,
                                           GLenum type,
                                           GLuint id,
                                           GLenum severity,
                                           GLsizei length,
                                           const GLchar* message,
                                           void* userParam);

///Initialize StaticGLAttribStack.
MG_DLL_DECLR void initializeStaticGLAttribStack();

///Set static color as selection name.
void setColorAsSelectionName(unsigned name);

std::stack<mgStaticGLAttrib>&  getStaticGLAttribStack();
mgStaticGLAttrib& getCurrentStaticGLAttrib();

void execStaticGLAttrib(const mgStaticGLAttrib& attrib);
void execStaticColorAttrib(const MGColor& color);
void execStaticColorAttrib(const float color[4]);
void execStaticLineWidth(float lineWidth);
void execStaticLineStipple(short int factor, GLuint pattern);
 void execLightMode(// set Light(Shading On/Off)
	int mode/// <0: undefined, =0:Light is disabled, >0:Light is enabled.
);
void pushStaticGLAttrib();
void popStaticGLAttrib();

};

///mgGLSLProgramOpenGL Shader Programcompile , linkĂuniformϐ̊Ǘs܂.

///p@F
///PAmgGLSLProgramIuWFNg̍쐬
///QAcompileShaderFromFileA܂compileShaderFromStringŕKvshader
///    RpC
///RAKvłbindAttribLocation(), bindFragDataLocation()Ă񂾌Alink()
///@use()ɂshadervOIAsetUniform()ɂuniformϐɒlZbg
///
///***** MGCLłshaderɑ΂Ďlocationƕϐ\񂵂ĂF
///locationɑ΂Ă̒l͎gpĂ͂ȂȂB
/// ܂A̕ϐׂ͂Ăvertex shaderɉL̂悤ɐ錾Ȃ΂ȂȂB
///uniform int functionID;//Function ID of the shaders:
///   0: standard(no shading functions);
///  11: Texture that uses texture1 sampler2D.(MGPlaneImage Texture uses this one.)
///	
/// uniform mat4 modelViewProjMatrix;//=projMatrix*modelViewMatrix.
/// uniform mat3 normalMatrix;
/// uniform mat4 modelViewMatrix;
/// uniform mat4 projMatrix;
/// uniform sampler2D texture1;
///
/// layout(location = 0) in vec3 vPosition;
/// layout(location = 1) in vec4 vColor;
/// layout(location = 2) in vec3 vNormal;
/// layout(location = 3) in vec2 vTextureCoord;
class MG_DLL_DECLR mgGLSLProgram{

public:
	//m_uniform_locations(UniformName) array size.
	static const size_t MAX_ATTRIB_LOC = 20;

	// Light܂
	static const GLint LIGHT_NUM = 10;
	static const GLint PROP_NUM = 11;

	/// CreateShader̃^Cv񋓎q
     typedef enum{
        VERTEX, FRAGMENT, GEOMETRY,
        TESS_CONTROL, TESS_EVALUATION
    } GLSLShaderType;

	///Vertex attribϐ`p
	typedef enum {
		vPosition=0,
		vColor,
		vNormal,
		vTextureCoord
	} VertexAttribId;

	union SELECT_NAME{
		unsigned uiName;
		unsigned short usName[2];
		unsigned char ucName[4];//
	};

	///Uniform name(id).
	//Last name of UNIFORM_ATTRIB_ID must be less than MAX_ATTRIB_LOC.
	typedef enum{
		modelViewProjMatrix = 0,	// mat4
		modelViewMatrix,		// mat4
		projMatrix,				// mat4
		normalMatrix,			// mat3 

		ndcMarix,				// mat4
		ndcScaleMatrix,			// mat3
		dpiFactor,				// float

		FuncType,               // draw function(Draw/Select/Zebra Analysis) FuncTypeEnum`
		DrawType,				// func typeDraŵƂ̂ݗL DrawTypeEnum`
		ShaderMode,				// int 0:NoShading 1:Shading

		CoordinateType,			// CoordinateType (World/NDC/AnchorPoint/AnchorPointScreen) CoordinateTypeEnum`

		texture2D,				// texture.
		pointSize,				// Vertex̕\TCYBJ[\ȂǂPOINT_SPLITE\Ɏg

		anchorPoint,			// AnchorPointBBillboard\(gBkĂTCYςȂ`)̊_

		LightTwoSides,			// boolean True:TwoSide, False:Ж
		ForceLight,				// falsêƂ́ALLightꍇ́ANO_SHADING[hŕ`B

		ZebraAxis,				// [u ZebraTypeŎw
		ZebraSize,				// [u̕B [ũXebv݂ step(0.5f, fract(1.0f / ZebraSize * atan(r.y, r.x)));
	}UniformName;

	///Light property.
	typedef enum {
		isEnabled = 0,	// bool
		ambientColor,	// vec4 ambient Color
		diffuseColor,	// vec4 diffulse color
		specularColor,	// vec4 specular color
		position,		// vec4 position
		spotDirection,	// vec3
		spotExponent,	// float
		spotCutoff,		// float
		constantAttenuation,	// float
		linearAttenuation,		// float
		quadraticAttenuation	// float
	}LightProps;

private://Member data.
	static mgGLSLProgram* m_CurrrentGLSL;//The current glslProgram to use.

	int  m_handle;///<Shader program handler.
	GLint m_VersionMajor, m_VersionMinor;//OpenGL version.
	bool m_linked;//If the program is linked or not.
	std::string m_logString;

	//Tehese values are set when mgGLSLProgram::link() is invoked.
	GLint m_uniform_locations[MAX_ATTRIB_LOC];//uniform loc of UniformName.
	GLint m_LightPropsIds[LIGHT_NUM][PROP_NUM];//uniform loc of lights.

public:
	mgGLSLProgram();
	~mgGLSLProgram();

	///compile܂sꂽƂtrueAsƂfalseԂ܂
    bool compileShaderFromFile(const char* fileName, GLSLShaderType type);

    ///compile܂sꂽƂtrueAsƂfalseԂ܂
	bool compileShaderFromString(const std::string& source, GLSLShaderType type);

	///Delete this program and initialize this.
	void freeProgram();

    ///link܂sꂽƂtrueAsƂfalseԂ܂
	bool link();

	///mgGLSLProgram̗pJn܂B
    void use();

	///G[ÑOe𕶎ŋ߂܂
    std::string& log();

	///ProgramnhԂ܂
    int getHandle();

	///Linkςۂq˂
    bool isLinked();

	///nameɊ蓖Ălocationw肷Blocation͂̌link()ŗLƂȂB
    void bindAttribLocation( GLuint location, const char * name);

	///Current mgGLSLProgram߂B
	static void setCurrentGLSLProgram(mgGLSLProgram* glsl);

	///Current mgGLSLProgram߂B
	static mgGLSLProgram* getCurrentGLSLProgram();

	///nameɊ蓖Ălocationw肷Blocation͂̌link()ŗLƂȂB
	void bindFragDataLocation( GLuint location, const char * name );

	///Kvetex attrib location߂B
	int getvPositionLocation()const;///vPosition
	int getvColorLocation()const;///vColor
	int getvNormalLocation()const;///vNormal
	int getvTextureCoordLocation()const;///vTexture

	/// Get Uniform location.
	GLint getUniformLocation(const char* name)const;
	GLint getUniformLocation(const std::string& name)const{
		return getUniformLocation(name.c_str());
	};

	/// UniformɒlZbg(invoke glUniform)֐QB

	/// loc is a uniform location obtained by getUniformLocation,
	/// which is stored in m_uniform_locations
    void setUniform( GLint loc, float x, float y, float z);
    void setUniform( GLint loc, const glm::vec3& v);
    void setUniform( GLint loc, const glm::vec4& v);
    void setUniform( GLint loc, const glm::mat4& m);
    void setUniform( GLint loc, const glm::mat3& m);
    void setUniform( GLint loc, float val);
    void setUniform( GLint loc, int val);
    void setUniform( GLint loc, bool val);

	///Functions to store data in uniform variables(invoke glUniform) through UniformName.
	void setUniform(UniformName name, float x, float y, float z);
	void setUniform(UniformName name, const glm::vec3& v);
	void setUniform(UniformName name, const glm::vec4& v);
	void setUniform(UniformName name, const glm::mat4& m);
	void setUniform(UniformName name, const glm::mat3& m);
	void setUniform(UniformName name, float val);
	void setUniform(UniformName name, int val);
	void setUniform(UniformName name, bool val);

	///Enable lights when bEnabled=true, else disable.
	void EnableLights(bool bEnabled = true);

	///Test if light is enabled.
	bool LightEnabled();

	///Functions to set light data in uniform variables(invoke glUniform).
    void setUniformLights( GLint lightNo, LightProps name, float x, float y, float z);
    void setUniformLights( GLint lightNo, LightProps name, const glm::vec3& v);
    void setUniformLights( GLint lightNo, LightProps name, const glm::vec4& v);
    void setUniformLights( GLint lightNo, LightProps name, const glm::mat4& m);
    void setUniformLights( GLint lightNo, LightProps name, const glm::mat3& m);
    void setUniformLights( GLint lightNo, LightProps name, float val);
    void setUniformLights( GLint lightNo, LightProps name, int val);
    void setUniformLights( GLint lightNo, LightProps name, bool val);

	///Get version by glGetInteger(), and set the info in this program.
	void setOpenGLVersion();

	///Get OpendGL version obtained by setOpenGLVersion.
	void getOpenGLVerion(GLint& major, GLint& minor)const;

	///Print each info.
	void printActiveUniforms();
	void printActiveAttribs();
	void printPrjMatrix();
	void printLightProps();
	
	///Set & Get function type.
	void setFuncType(mgGLSL::FuncType type);
	int getFuncType();

	///Set & Get coordinate type.
	void setCoordinateType(mgGLSL::CoordinateType type);
	mgGLSL::CoordinateType getCoordinateType();

	///Get Anchoe position.
	void getAnchor(MGPosition& anchor);

private:
	//m_uniform_locations[]ɒlZbg(link()̏j
	void build_attribLocations();

	//m_uniform_locationsLights[]ɒlZbg(ling()̏j
	void build_attribLocationsLight();

    int  getAttribLocation(const char* name)const;
	bool fileExists(const std::string& fileName)const;
};

///Utility class to invoke glsl's setFuncType.

///mgFuncTypeSwitcher saves the current function type and invoke input function type.
///When mgFuncTypeSwitcher is destructed, the saved original type is restored.
class MG_DLL_DECLR mgFuncTypeSwitcher{
public:
	mgFuncTypeSwitcher(mgGLSL::FuncType type);

	~mgFuncTypeSwitcher();

private:
	mgGLSLProgram* m_pGLSL;//The current glsl program is saved.
	int m_orgFuncType;//The original function type is saved.
};

///mgCoordinateTypeSwitcher saves the current coordinate type and invoke input coordinate type.

///When mgCoordinateTypeSwitcher is destructed, the saved original type is restored.
class MG_DLL_DECLR mgCoordinateTypeSwitcher{
public:
	mgCoordinateTypeSwitcher(mgGLSL::CoordinateType coordinateType, const MGPosition* anchorP = nullptr);

	~mgCoordinateTypeSwitcher();

private:
	mgGLSLProgram* m_pGLSL;//The current glsl program is saved.
	mgGLSL::CoordinateType m_coordinateType;
	MGPosition m_anchorPoint;//Valid only when m_coordinateType=AnchorPoint or AnchorPointScreen.
};

/** @} */ // end of DisplayHandling group

#endif // _MGGLSLPROGRAM_H
