/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#ifndef _MGHHisect_vector_HH_
#define _MGHHisect_vector_HH_
/** @file */
/** @addtogroup IsectContainer
 *  @{
 */

#include <vector>
#include "topo/HHisect.h"

//Forward class declaration.

///MGHHisect_vector defines a vector of MGHHisect.

///The vector is implemeted using STL's vector.
///All the methods to handle the vector are available from the STL's vector class,
///and public member m_HHivector. Refer to STL vector class.
///MGHHisect_vector is used to represent intersection lines of a shell with
///another shell, a face, or a surface.
class MG_DLL_DECLR MGHHisect_vector{
//We cannot use inheritance of std::vector<MYELM> to make DLL.

public:

using MYELM = MGHHisect;
using MYVEC = std::vector<MYELM>;

typedef MYVEC::reference              reference;
typedef MYVEC::const_reference        const_reference;
typedef MYVEC::iterator               iterator;
typedef MYVEC::const_iterator         const_iterator;
typedef MYVEC::size_type              size_type;
typedef MYVEC::difference_type        difference_type;
typedef MYVEC::value_type             value_type;
typedef MYVEC::allocator_type         allocator_type;
typedef allocator_type::pointer       pointer;
typedef allocator_type::const_pointer const_pointer;
typedef MYVEC::reverse_iterator       reverse_iterator;
typedef MYVEC::const_reverse_iterator const_reverse_iterator;

MYVEC m_vec;

iterator begin() { return m_vec.begin(); };
iterator end() { return m_vec.end(); };
const_iterator begin()const { return m_vec.begin(); };
const_iterator end()const { return m_vec.end(); };
reverse_iterator rbegin() noexcept { return m_vec.rbegin(); };
reverse_iterator rend() noexcept { return m_vec.rend(); };
const_reverse_iterator rbegin() const noexcept { return m_vec.rbegin(); };
const_reverse_iterator rend() const noexcept { return m_vec.rend(); };
void clear() { m_vec.clear(); };
bool empty() const { return m_vec.empty(); };
template <class... Args>
void emplace_back(Args&&... args) { m_vec.emplace_back(std::forward<Args>(args)...); };
iterator erase(iterator x) { return m_vec.erase(x); };
iterator erase(iterator first, iterator last) { return m_vec.erase(first, last); };
const MYELM& front() const { return m_vec.front(); };
MYELM& front() { return m_vec.front(); };
const MYELM& back() const { return m_vec.back(); };
MYELM& back() { return m_vec.back(); };
iterator insert(iterator it, MYELM&& x) { return m_vec.insert(it, std::move(x)); };
template <class InputIterator>
iterator insert(const_iterator position,
	InputIterator first, InputIterator last) {
	return m_vec.insert(position, first, last);
};
void pop_back() { m_vec.pop_back(); };
void push_back(MYELM&& x) { m_vec.push_back(std::move(x)); };//Only move is allowed.
void reserve(size_type n) { m_vec.reserve(n); };
size_t size() const { return m_vec.size(); };
MYELM& operator[](size_t i) { return m_vec.operator[](i); };
const MYELM& operator[](size_t i)const { return m_vec.operator[](i); };

///String stream Function
MG_DLL_DECLR friend std::ostream & operator << (std::ostream&, const MGHHisect_vector& );

//////////// Constructor ////////////

////////Special member functions/////////
MGHHisect_vector() = default;
~MGHHisect_vector() = default;
MGHHisect_vector(const MGHHisect_vector&) = delete;
MGHHisect_vector& operator=(const MGHHisect_vector&) = delete;
MGHHisect_vector(MGHHisect_vector&&) = default;
MGHHisect_vector& operator=(MGHHisect_vector&&) = default;

///Constructor of 1 MGHHisect.
explicit MGHHisect_vector(MGHHisect&& hhi);

//////////// Member Function. ////////////

///Adds one MGHHisect to the end of the vector.
///Transfers the ownership of the curves in isect to this vector.
//void push_back(MGHHisect& isect){ std::vector<MGHHisect>::push_back(isect); };
void append(
	const MGFSurface* face1,	//face1. This must not be null.
	const MGFSurface* face2,	//face2. This may be null
								//(e.g. for face2 that is actually a surface).
	MGSSisect& ssi);			//intersection line of face1 and face2 expressed as

///Replace first and second order of surface 1 and 2.
MGHHisect_vector& replace12();

private:

};

/** @} */ // end of IsectContainer group
#endif
