////////////////////////////////////////////////////////////////////////////
// CTaEditDoc 饹Υ󥿥ե
//
////////////////////////////////////////////////////////////////////////////

#if !defined( TAEDITDOC_H_INCLUDED_ )
#define TAEDITDOC_H_INCLUDED_

#include <Xm/XmAll.h>

#include "TaEdit_std.h"
#include "LineData.h"
#include "UndoListMgr.h"
#include "EditCommand.h"
#include "lang/TxtColorMgr.h"

using namespace NLangExt;

class CTaEditDoc
{
public:
	CTaEditDoc();
	~CTaEditDoc();

	// եɤ߹
	CErrorBool OnOpenDocument( const string &argFileName, bool *pIsChanged );

	// ե¸
	CErrorBool OnSaveDocument( const string &argFileName );

	// ե̾λ
	const string& GetFileName() const;

	// 
	void Initialize();

	// ʸ
	CErrorBool Insert( const wstring& rStr, const T_CurPos &rCurPos, const T_SelRange &rSelRange, T_CurPos *pResultCurPos );

	// ü쵭
	CErrorBool InsertSpecialCode( KeySym argKeySym, const T_CurPos &rCurPos, const T_SelRange &rSelRange, T_CurPos *pResultCurPos );

	// ʣԤؤTAB
	CErrorBool MultiLineTabInsert( const T_SelRange &rSelRange, T_CurPos *pResultCurPos, T_SelRange *pResultSelRange );

	// ʣԤTABκ
	CErrorBool MultiLineTabDelete( const T_SelRange &rSelRange, T_CurPos *pResultCurPos, T_SelRange *pResultSelRange );

	const T_LineData& RefData() const;

	// ե饰
	bool GetIsModify() const;

	// ɥǽݤ
	bool EnableUndo() const;

	// ɥǽݤ
	bool EnableRedo() const;

	// ɥ
	void Undo( T_SelRange *pAfterUndoSelRange, T_CurPos *pAfterUndoCurPos );

	// ɥ
	void Redo( T_SelRange *pAfterRedoSelRange, T_CurPos *pAfterRedoCurPos );

	// ꤷϰϤʸ
	void GetRangeStr( const T_SelRange &range, wstring *pStr );

	// ¸󥪥֥Ȥ
	const NLangExt::CTxtColorMgr* GetTxtColorMgr() const;

	// 󥪥֥Ȥ
	bool SetTxtColorMgr( enumLANGTYPE type );

protected:

	// ꤷ֤¸ߤ롢ꤷʸ
	CErrorBool DelSpecifiedStr( T_CurPos pos, const wstring &rStr );

	// ꤷ֤˻ꤷʸʲԥɤޤˤɲä
	void InsertSpecifiedStr( T_CurPos pos, const wstring &rStr );

	// ꤷϰϤԽޥɥ֥Ȥۤ
	CErrorBool Delete_WithCreateEC( T_SelRange DelRange, T_CurPos BeforeCurPos );

	// 
	void AddCR( T_CurPos pos );

	// ưǥȤˤĴ
	int ExecAutoIndent( int line );

	// ʸκ
	CErrorBool Delete( const T_SelRange &rRange );

	// Խޥɥ֥Ȥ
	VClsPtr< CEditCommand > CreateEditCommandObj( enumTEC_TYPE argType );

	// եξ֤ǧ
	CErrorBool CheckFileStatus( const string &rFileName, bool Exist );

	// ¸󥪥֥Ȥ򹹿
	void UpdateTextColorMgr();

protected:
	// ʸݻ
	T_LineData vecLine;

	// ե̾
	string FileName;

	// Ǹ¸Ƥѹ줿ݤ
	bool IsModify;

	// Undoꥹȴ֥
	CUndoListMgr UndoListMgr;

	// ¸󥪥֥
	NLangExt::CTxtColorMgr *pTxtColorMgr;
};

#endif // TAEDITDOC_H_INCLUDED_

