////////////////////////////////////////////////////////////////////////////
// CTaEditFileSelDlg 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEditFileSelDlg.h"
#include <Xm/XmAll.h>
#include <Xm/FileSBP.h>
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTaEditFileSelDlg::CTaEditFileSelDlg()
{
	IsSelected = false;
	SelectedFile = "";
}

CTaEditFileSelDlg::~CTaEditFileSelDlg()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 󥻥ܥβ
void CTaEditFileSelDlg::OnCancel( Widget argWgt, XtPointer user_data )
{
	m_ModalDlg.ExitModal();	// ⡼νλ
	IsSelected = false;	// ߤ줿
	SelectedFile = "";
}

// ϣ˥ܥβ
void CTaEditFileSelDlg::OnOK( Widget argWgt, XtPointer user_data )
{
	char *pFileName;
	char *pDirName;
	string strFileName;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	// ǥ쥯ȥ̾
	if ( !XmStringGetLtoR( FS_Directory( m_FileSelectDlg ), XmFONTLIST_DEFAULT_TAG, &pDirName ) ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefUnexpectedErrorMsg() );
		return ;
	}

	// ե̾
	pFileName = XmTextGetString( m_FileNameText );
	strFileName = pFileName;

	// եѥΥե̾
	SelectedFile = pDirName;
	SelectedFile += strFileName;

	XtFree( pFileName );
	XtFree( pDirName );

	if ( strFileName.empty() ) {
		m_TaEditShell->ShowErrorMsgBox( pConf->RefFileNameIsNotInputtedErrorMsg() );
		return ;
	}

	m_ModalDlg.ExitModal();	// ⡼νλ
	IsSelected = true;
}

// ɽ
void CTaEditFileSelDlg::OnShow( Widget argWgt, XtPointer user_data )
{
	XmFileSelectionDoSearch( m_FileSelectDlg, CCompoundStr( "*" ) );
}

// Υȥ
void CTaEditFileSelDlg::SetDlgTitle( const CCompoundStr &rStr ) const
{
	int ac = 0;
	Arg al[2];

	XtSetArg( al[ac], XmNdialogTitle, rStr.GetStr() ); ac++;
	XtSetValues( m_FileSelectDlg, al, ac );
}

// ɽ
// ݤ֤
bool CTaEditFileSelDlg::ShowDlg( string *pSelectedFile )
{
	SelectedFile = "";

	// ⡼ɽ
	m_ModalDlg.DoModal( m_FileSelectDlg );

	(*pSelectedFile) = SelectedFile;
	return IsSelected;
}

// եѥ⤷ʤե̾顢ե̾ΤߤФ
const char* CTaEditFileSelDlg::FullPathToFileName( const char *pFileName ) const
{
	int slen = strlen( pFileName );
	for (; slen > 0 && pFileName[ slen ] != '/'; slen-- );
	return pFileName + slen;
}

