////////////////////////////////////////////////////////////////////////////
// CTargetFile 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "Server_glo.h"

#include "TargetFile.h"

using namespace std;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTargetFile::CTargetFile() :
	FileName(),
	EnableStatInfo( false )
{

}

CTargetFile::CTargetFile( const CTargetFile& r ) :
	FileName( r.FileName ),
	EnableStatInfo( r.EnableStatInfo ),
	INodeNumber( r.INodeNumber ),
	DeviceID( r.DeviceID )
{
}

CTargetFile::CTargetFile( const std::string &argFName ) :
	FileName( argFName ),
	EnableStatInfo( false )
{
	UpdateStatInfo();
}

CTargetFile::~CTargetFile()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ե̾
void CTargetFile::SetFileName( std::string &argFileName )
{
	assert( NULL != this );
	FileName = argFileName;
	EnableStatInfo = false;
	UpdateStatInfo();
}

// ӡƱեؤƤ뤫ݤ
bool CTargetFile::operator ==( const CTargetFile &r ) const
{
	assert( NULL != this );

	// ɤ餫Υե̾äϡ֤
	// ̵̾Υեʣμɮݻ뤳ȤǤ뤿
	if ( FileName.empty() || r.GetFileName().empty() ) return false;

	// ɤ餫I-NodeǥХIDѤǤʤäϡ
	// ե̾ӤԤ
	if ( !IsEnableStatInfo() || !r.IsEnableStatInfo() )
		return ( r.GetFileName() == FileName );

	// I-NodeǥХIDӤԤ
	return r.INodeNumber == INodeNumber && r.DeviceID == DeviceID;
}

// 
bool CTargetFile::operator !=( const CTargetFile &r ) const
{
	return !( operator ==( r ) );
}

// ե̾λ
const std::string& CTargetFile::GetFileName() const
{
	assert( NULL != this );
	return FileName;
}

// i-NodeǥХIDξѲǽݤ
bool CTargetFile::IsEnableStatInfo() const
{
	assert( NULL != this );

	return EnableStatInfo;
}

// 
const CTargetFile& CTargetFile::operator =( const CTargetFile& r )
{
	FileName = r.FileName;
	EnableStatInfo = r.EnableStatInfo;
	INodeNumber = r.INodeNumber;
	DeviceID = r.DeviceID;
	return (*this);
}

// i-NodeǥХIDξ򹹿
void CTargetFile::UpdateStatInfo()
{
	struct stat s;

	assert( NULL != this );

	// ե̾ǤСμԲǽ
	if ( FileName.empty() ) {
		EnableStatInfo = false;
		return ;
	}

	// եξ
	if ( stat( FileName.c_str(), &s ) != 0 ) {
		// Ԥ
		EnableStatInfo = false;
		return ;
	}

	EnableStatInfo = true;
	INodeNumber = s.st_ino;;
	DeviceID = s.st_dev;
}

