/*/////////////////////////////////////////////////////////////////////////////
// confman ϥ饤֥
// ConfImp.h CConfImp饹󥿥ե
*/

#ifndef CONFIMP_H_INCLUDED_
#define COMPIMP_H_INCLUDED_

#include "confman.h"

#include <map>
#include <string>
#include <wchar.h>

using namespace::std;

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <wchar.h>

typedef map< wstring, wstring > SEC_TYPE;
typedef map< wstring, SEC_TYPE > CONF_TYPE;
typedef CONF_TYPE::iterator CONF_ITR;
typedef SEC_TYPE::iterator SEC_ITR;

// Ϥʸɽ
struct tagCFChar {
	unsigned int type;	// üʸξϤμ򼨤
	wchar_t c;		// ɤ߹ʸ
};

// 嵭tagCFChar.typeǻѤ륳
#define CFCT_ERR	-1
#define CFCT_COMMENT	1	// ;
#define CFCT_RETURN	2	// \n
#define CFCT_EQUAL	3	// =
#define CFCT_SPACE	4	//  
#define CFCT_TAB	5	// \t
#define CFCT_LS		6	// [
#define CFCT_RS		7	// ]
#define CFCT_ELSE	8

class CConfImp
{
public:
	CConfImp( );
	CConfImp( const CConfImp &r );	// ʣʶػߡ
	~CConfImp( );

	// 󥿥ե
	void ConfImp_SetFileName( const char *FileName );
	CF_BOOL ConfImp_Open();
	CF_BOOL ConfImp_GetString( const wchar_t *SectionName, const wchar_t *KeyName, wchar_t *buf, int length );
	CF_BOOL ConfImp_SetString( const wchar_t *SectionName, const wchar_t *KeyName, const wchar_t *value );
	CF_BOOL ConfImp_Close();
	CF_BOOL ConfImp_GetSectionList( wstring &s, int Length );
	CF_BOOL ConfImp_GetKeyList( const wchar_t *SectionName, wstring &s, int Length );

	CF_BOOL ConfImp_AddSection( const wchar_t *SectionName );
	CF_BOOL ConfImp_AddKey( const wchar_t *SectionName, const wchar_t *KeyName, const wchar_t *Value );
	CF_BOOL ConfImp_RemoveSection( const wchar_t *SectionName );
	CF_BOOL ConfImp_RemoveKey( const wchar_t *SectionName, const wchar_t *KeyName );
	unsigned long ConfImp_GetLastError();
	void ConfImp_ClearLastError();
	const wchar_t* ConfImp_GetConstStr( const wchar_t *SectionName, const wchar_t *KeyName );

	// ե饰
	CF_BOOL ConfImp_GetModifyFlag( void );
	void ConfImp_SetModifyFlag( CF_BOOL b );

	// ǻѤ륤󥿥ե
	CF_BOOL ConfImp_GetSTLString( const wchar_t *SectionName, const wchar_t *KeyName, wstring &str );
	void ConfImp_SetError( unsigned long e );

	// ʶػߡ
	const CConfImp& operator =( const CConfImp &r );

protected:
	// ɤ߹
	map< wstring, map< wstring, wstring > > mapConfig;
	// ¸˻Ѥե̾
	string strFileName;
	// ե饰
	CF_BOOL ModifyFlag;
	// ǽ顼
	unsigned long LastError;

protected:
	// եɤ߹ߥ롼
	CF_BOOL ReadFile( FILE *in_file );
	int ReadSectionName( FILE *in_file, wstring *name );
	int CreateSection( FILE *in_file, SEC_TYPE *sec );
	int LineEndSkip( FILE *in_file );
	int LineHeadSkip( FILE *in_file, tagCFChar *ch, int *EXIT_stat );
	int ReadKeyVal( FILE *in_file, tagCFChar ch, SEC_TYPE *sec );

	tagCFChar GetChar( FILE *infile );	// ʸɤ߹

	// ѲƯ롼
	CF_BOOL FindKey( const wchar_t *SectionName, const wchar_t *KeyName, SEC_ITR *p );

	// եν
	CF_BOOL WriteFile( void );
	bool WriteLine( FILE *out_file, wstring *str );

	// ̾̾ΥꥹȺ
	template <class TYPE> CF_BOOL MakeList( TYPE s, TYPE e, wstring &buf, int Length );
};

#endif // COMPIMP_H_INCLUDED_

