////////////////////////////////////////////////////////////////////////////
// CFileName 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "conv_glo.h"
#include "FileName.h"

using namespace std;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CFileName::CFileName()
{
	FileName = "";
}

CFileName::CFileName( const char* pArgName )
{
	Set( pArgName );
}

CFileName::CFileName( const CFileName& r )
{
	Set( r.FileName.c_str() );
}

CFileName::~CFileName()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ե̾
void CFileName::Set( const char* pArgName )
{
	// NULLĹ0ʸ󤬻ꤵ줿ϡʤˤ⤷ʤ
	if ( NULL == pArgName ) return ;
	if ( strlen( pArgName ) == 0 ) return ;

	// ꤵ줿ѥ̾ݻ
	FileName = Normalization( pArgName );
}

// ʬ
vector< string > CFileName::Divide() const
{
	vector< string > rv;
	DivideFileName( &rv, FileName );
	return rv;
}

// եѥݤ
bool CFileName::IsFullPath() const
{
	if ( FileName.empty() ) return false;
	return ( FileName[0] == '/' );
}

// ѥ̾褹
void CFileName::Resolv( const char *pRoot )
{
	// Ǥ˥եѥǤä顢äˤ뤳ȤϤʤ
	if ( IsFullPath() ) return ;

	string wstr = pRoot;
	wstr += "/";
	wstr += FileName;
	FileName = Normalization( wstr );
}

// ե̾Ϣ뤷֥ǥ쥯ȥذư
void CFileName::MoveTo( const char *pName )
{
	// NULLĹ0ʸ󤬻ꤵ줿ϡʤˤ⤷ʤ
	if ( NULL == pName ) return ;
	if ( strlen( pName ) == 0 ) return ;

	// եѥꤵ줿ϡꤵ줿ѥ̾򤽤Τޤ޼
	if ( pName[0] == '/' ) {
		Set( pName );
		return ;
	}

	// ݻƤѥ̾Ϣ뤷ơԤ
	FileName = Normalization( GetSafeDirName() + pName );
}

// /ĤƤ뤳Ȥݾڤơѥ̾
string CFileName::GetSafeDirName() const
{
	if ( FileName.empty() ) return "/";
	if ( FileName[ FileName.length() - 1 ] != '/' )
		return FileName + "/";
	else
		return FileName;
}

// /ĤƤʤȤݾڤơѥ̾
string CFileName::GetSafeFileName() const
{
	if ( FileName.empty() ) return "";
	if ( FileName[ FileName.length() - 1 ] == '/' )
		return string( FileName, FileName.length() - 1 );
	else
		return FileName;
}

// ݻƤѥ̾򻲾
const string& CFileName::GetFileName() const
{
	return FileName;
}

// Ϳ줿ѥ̾
string CFileName::Normalization( const string &r ) const
{
	vector< string > wv;
	vector< string > rv;
	string rs;
	int i;
	bool IsFullPath;

	// ""Ϥ줿äˤʤˤ⤹뤳ȤϤʤ
	if ( r.empty() ) return "";

	// ǥեѥݤȽǤ
	IsFullPath = ( r[0] == '/' );

	DivideFileName( &wv, r );

	// Ϣ³/.ν..ν
	for ( i = 0; i < wv.size(); i++ ) {
		if ( wv[i] == "" || wv[i] == "." ) continue;
		if ( wv[i] == ".." ) {
			if ( rv.size() > 0 )
				rv.pop_back();
			else {
				// Хѥξϡ..äƤϤʤ
				if ( !IsFullPath )
					rv.push_back( wv[i] );
			}
		}
		else
			rv.push_back( wv[i] );
	}

	// ʬǤ줿̾Ϣ뤹
	if ( IsFullPath )
		rs = "/";
	else
		rs = "";
	for ( i = 0; i < rv.size() - 1; i++ ) {
		rs += rv[i];
		rs += "/";
	}
	rs += rv[i];
	return rs;
}

// եμ̤
bool CFileName::GetStatus( bool *pIsNormalFile, bool *pIsDir, ino_t *pInodeNum )
{
	struct stat wStat;

	// ֤
	if ( stat( FileName.c_str(), &wStat ) )
		return false;

	// ͤ˳Ǽ
	if ( pIsNormalFile )
		(*pIsNormalFile) = ( wStat.st_mode & S_IFREG ) ? true : false;
	if ( pIsDir )
		(*pIsDir) = ( wStat.st_mode & S_IFDIR ) ? true : false;
	if ( pInodeNum )
		(*pInodeNum) = wStat.st_ino;
	return true;
}

// ǥ쥯ȥΥե롦ǥ쥯ȥ̾
vector< string > CFileName::ListDir() const
{
	DIR *pDir;
	dirent *pDirEnt;
	vector< string > rv;

	// ǥ쥯ȥ򳫤
	pDir = opendir( GetSafeDirName().c_str() );
	if ( NULL == pDir ) return rv;

	pDirEnt = readdir( pDir );
	while ( NULL != pDirEnt ) {
		// .ޤ..ϽϤʤ
		if ( strcmp( pDirEnt->d_name, "." ) && strcmp( pDirEnt->d_name, ".." ) )
			rv.push_back( pDirEnt->d_name );
		pDirEnt = readdir( pDir );
	}
	closedir( pDir );
	return rv;
}

// Ϳ줿ե̾/ʬ䤹
void CFileName::DivideFileName( vector< string > *pVec, const string &rFName ) const
{
	int i;
	int h;

	// rFName/ǶڤäpVec˳Ǽ
	i = 0;
	while ( i < rFName.length() ) {
		h = i;
		for (; i < rFName.length() && rFName[i] != '/'; i++ );
		pVec->push_back( string( rFName, h, i- h ) );
		i++;
	}
}

// 
const CFileName& CFileName::operator =( const CFileName& r )
{
	Set( r.FileName.c_str() );
	return (*this);
}

