////////////////////////////////////////////////////////////////////////////
// CAlias 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "Alias.h"
#include "GlbFunc.h"
#include <stdio.h>
#include <assert.h>

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CAlias::CAlias() :
	mapAlias()
{
	mapAlias.clear();
}

CAlias::CAlias( const CAlias& r ) :
	mapAlias( r.mapAlias )
{

}

CAlias::~CAlias()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
bool CAlias::Initialize()
{
	mapAlias.clear();
	return true;
}

// ꥢեɤ߹
bool CAlias::AddAliasFile( const char* pAliasFile )
{
	FILE *infile;
	string Line;
	string LeftStr, RightStr;
	int i;
	map< string, string >::iterator itr;

	assert( pAliasFile );

	infile = fopen( pAliasFile, "r" );
	if ( NULL == infile ) return false;

	while ( !ferror( infile ) && !feof( infile ) ) {
		// ɤ߹
		GlbFunc::ReadLine( infile, &Line );

		// ;ʬʶ
		Line = GlbFunc::Trim( Line, " \t\n\r", " \t\n\r" );
		if ( Line.length() == 0 ) continue;

		// Ƭ#ǻϤޤԤϥȤǤ
		if ( Line[0] == '#' ) continue;

		// ʸڤ򸡺
		for ( i = 0; i < Line.length(); i++ ) {
			if ( Line[i] == ' ' || Line[i] == '\t' )
				break;
		}
		if ( i == 0 || i >= Line.length() - 1 ) continue;

		// ꥢȼ̾
		LeftStr = GlbFunc::Trim( GlbFunc::ToUpper( Line.substr( 0, i ) ), " \t", " \t" );
		RightStr = GlbFunc::Trim( Line.substr( i + 1 ), " \t", " \t" );

		// ǤϿƤϡ¸ΤΤ
		itr = mapAlias.find( LeftStr );
		if ( itr != mapAlias.end() )
			mapAlias.erase( itr );

		// Ͽ
		mapAlias.insert( pair< string, string >( LeftStr, RightStr ) );
	}

	if ( ferror( infile ) ) {
		fclose( infile );
		return false;
	}
	fclose( infile );
	infile = NULL;

	// ꥢǤϤʤ󥳡̾Ͽ
	for ( itr = mapAlias.begin(); itr != mapAlias.end(); itr++ ) {
		string wStr = GlbFunc::ToUpper( itr->second );
		map< string, string >::iterator itr2 = mapAlias.find( wStr );
		if ( itr2 == mapAlias.end() ) {
			mapAlias.insert( pair< string, string >( wStr, itr->second ) );
		}
	}

	return true;
}

// Ѵ
const string& CAlias::TransName( const string &rName )
{
	map< string, string >::iterator itr;
	string wstr = GlbFunc::ToUpper( rName );

	// map򸡺
	itr = mapAlias.find( wstr );
	if ( itr != mapAlias.end() )
		return itr->second;
	else
		return rName;	
}

// 
const CAlias& CAlias::operator =( const CAlias& r )
{
	mapAlias = r.mapAlias;
	return (*this);
}
