////////////////////////////////////////////////////////////////////////////
// CMsgQueue 饹Υ󥿥ե
//
// å塼
////////////////////////////////////////////////////////////////////////////

#if !defined( MSGQUEUE_H_INCLUDED_ )
#define MSGQUEUE_H_INCLUDED_

#include <list>
#include <assert.h>
#include "Semaphore.h"
#include "Mutex.h"

template < typename T_MSG >
class CMsgQueue
{
public:
	CMsgQueue() :
		semaWait( 0 ),
		ExitFlg( false )
	{};

	~CMsgQueue(){};

	// 
	bool Initialize()
	{
		if ( !ListLock.Initialize() ) return false;
		if ( !ExitFlgLock.Initialize() ) return false;
		listJob.clear();
		return true;
	};

	// ꥹȤ˻Żɲä
	void push( const T_MSG &r )
	{
		assert( NULL != this );

		// ꥹȤФ¾ݤ
		ListLock.Unlock();

		// ꥹȤɲä
		listJob.push_back( r );

		// listJobɲä줿ʬsemaWaitû
		semaWait.V();

		// ¾
		ListLock.Unlock();
	};

	// ꥹȤŻФ
	bool pop( T_MSG *pJob )
	{
		int flg;

		assert( NULL != this && NULL != pJob );

		// listJob˥ǡɲäޤԤ碌
		semaWait.P();

		// ExitFlgФ¾ݤ
		ExitFlgLock.Lock();

		// λե饰ͤ
		// ѿflgϥåɥǤ뤳Ȥ
		flg = ExitFlg;

		// ExitFlgФ¾
		ExitFlgLock.Unlock();

		if ( flg ) {
			// ߤݤƤ

			// semaWaitԤäƤ¾Υåɤư褦ˤƤ
			semaWait.V();
			return false;
		}

		// ꥹȤФ¾ݤ
		ListLock.Unlock();

		// ꥹȤŻФ
		(*pJob) = *( listJob.begin() );
		listJob.erase( listJob.begin() );

		// ¾
		ListLock.Unlock();

		return true;
	};

	// 
	void Interrupt()
	{
		// ExitFlgФ¾ݤ
		ExitFlgLock.Lock();

		// λե饰ꤹ
		ExitFlg = true;

		// semaWaitԤ碌Ƥ륹åɤ餻Ƥ
		semaWait.V();

		// ExitFlgФ¾
		ExitFlgLock.Unlock();
	};

protected:
	// ֻŻפΥꥹ
	std::list< T_MSG > listJob;

	// listJob˥Ԥ¾
	CMutex ListLock;

	// listJob˥ǡޤǤԤ碌
	CSemaphore semaWait;

	// λե饰
	volatile bool ExitFlg;

	// ExitFlgФ¾
	CMutex ExitFlgLock;
};

#endif // MSGQUEUE_H_INCLUDED_
