////////////////////////////////////////////////////////////////////////////
// CMutex 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <pthread.h>
#include <assert.h>
#include "Mutex.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CMutex::CMutex() :
	IsEnable( false )
{

}

CMutex::~CMutex()
{
	if ( IsEnable )
		Destroy();
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
bool CMutex::Initialize()
{
	assert( NULL != this );

	// ¸mutex˴
	if ( IsEnable )
		Destroy();
	if ( pthread_mutex_init( &mutex, NULL ) == 0 )
		IsEnable = true;
	return IsEnable;
}

// ˴
bool CMutex::Destroy()
{
	assert( NULL != this );
	if ( !IsEnable ) return true;
	bool r = pthread_mutex_destroy( &mutex ) == 0 ? true : false;
	IsEnable = false;
	return r;
}

// ͭ
bool CMutex::Lock()
{
	assert( NULL != this && IsEnable );
	return pthread_mutex_lock( &mutex ) == 0 ? true : false;
}

// ͭߤ
bool CMutex::TryLock()
{
	assert( NULL != this && IsEnable );
	return pthread_mutex_trylock( &mutex ) == 0 ? true : false;
}

// 
bool CMutex::Unlock()
{
	assert( NULL != this && IsEnable );
	return pthread_mutex_unlock( &mutex ) == 0 ? true : false;
}

// Ԥ֤ꤷԤ碌
bool CMutex::WaitForTime( int ms )
{
	// 100msñ̤TryԤ
	// ms֤Ԥ碌

	struct timespec req;
	int cnt = ms / 100;	// TryԤ
	int i;

	// 100msñ̤TryԤ
	req.tv_sec = 0;
	req.tv_nsec = 100 * 1000 * 1000;

	for ( i = 0; i < cnt; i++ ) {
		// 100msԤ碌
		if( nanosleep( &req, NULL ) ) return false;
		// ͭߤ
		if ( TryLock() ) return true;
	}

	// 100msξ;֤Ԥ碌
	req.tv_nsec = ( ms % 100 ) * 1000 * 1000;
	if( nanosleep( &req, NULL ) ) return false;

	// Ǹ˰ͭߤ
	return TryLock();
}
