////////////////////////////////////////////////////////////////////////////
// CProcStart 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <alloca.h>
#include <sys/wait.h>
#include <assert.h>
#include <time.h>
#include <sys/stat.h>

#include "ProcStart.h"
#include "FD.h"
#include "GlbFunc.h"


////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CProcStart::CProcStart() :
	cmd(),
	listArg()
{

}

CProcStart::~CProcStart()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ư륳ޥɤ
bool CProcStart::SpecifyCommand( const string& rCmd )
{
	struct  stat fs;
	uid_t e_uid;	// ¸UID
	gid_t e_gid;	// ¸GID

	assert( NULL != this );

	// ư륳ޥɤΡ¸ߤ̵ͭǧ
	if ( stat( rCmd.c_str(), &fs ) ) {
		// ե뤬¸ߤ¹ԤǤȤϻפʤ
		return false;
	}

	// եμǧ
	if ( !( fs.st_mode & S_IFREG ) ) {
		// ̾ΥեǤϤʤᡢ¹ԤǤȤϻפʤ
		return false;
	}

	// ¸UIDGID
	e_uid = geteuid();
	e_gid = getegid();

	// եμ¹Բǽ°ǧ
	if ( fs.st_uid == e_uid ) {
		// UIDפ
		if ( !( fs.st_mode & S_IXUSR ) )
			return false;
	}
	else {
		if ( fs.st_gid == e_gid ) {
			// GIDפ
			if ( !( fs.st_mode & S_IXGRP ) )
				return false;
		}
		else {
			// UIDGIDȤ˰פʤä
			if ( !( fs.st_mode & S_IXOTH ) )
				return false;
		}
	}
	// ޥ̾	
	cmd = rCmd;
	listArg.clear();
	listArg.push_back( rCmd );

	return true;
}

// ɲ
void CProcStart::AddArg( const string& rArg )
{
	assert( NULL != this );
	listArg.push_back( rArg );
}

void CProcStart::AddArg( int a )
{
	assert( NULL != this );
	char Buf[32] = { 0 };
	snprintf( Buf, 31, "%d", a );
	AddArg( Buf );
}

void CProcStart::AddArg( double a )
{
	assert( NULL != this );
	char Buf[32] = { 0 };
	snprintf( Buf, 31, "%0.13e", a );
	AddArg( Buf );
}

// ץư˺ؤϥݡȤ
void CProcStart::AddAssignFile( FILE *pOld, FILE *pNew )
{
	assert( NULL != this );
	assert( NULL != pOld && NULL != pNew );
	listAssignFile.insert( listAssignFile.end(), pair< FILE*, FILE* >( pOld, pNew ) );
}

// ץư
// ưץpid֤
// Ԥ-1֤
int CProcStart::Start() const
{
	int r = 0;
	int status = 0;
	char **vArg = NULL;
	int vPipeD[2] = { -1, -1 };	// ƥץȻҥץ̿
	int ChildID;

	assert( NULL != this );

	// ̿ѤΥѥפ
	if ( pipe( vPipeD ) ) return -1;

	CFD FD_Read( vPipeD[0] );	// ɤ߹
	CFD FD_Write( vPipeD[1] );	// 񤭹
	vPipeD[0] = -1;
	vPipeD[1] = -1;

	// Ѱդ
	vArg = CreateArgVec();
	if ( NULL == vArg ) return -1;

	// Ϥ򺹤ؤ
	if ( !SwapIOPort() ) {
		FreeArgVec( vArg );
		vArg = NULL;
		return -1;
	}

	// ҥץ
	r = fork();
	if ( r < 0 ) {
		FreeArgVec( vArg );
		vArg = NULL;
		return -1;
	}

	if ( r > 0 ) {
		// ƥץ¦ν

		// ϻѤʤ
		FreeArgVec( vArg );
		vArg = NULL;

		// Ϥ򸵤᤹ʼԤƤˤϰʤ
		SwapIOPort();

		// ҥץνλԤ碌
		waitpid( r, &status, 0 );
		if ( !WIFEXITED( status ) ) return -1;

		// ҥץϡ0֤
		if ( WEXITSTATUS( status ) != 0 ) return -1;

		// ¹ץpid
		if ( !FD_Read.Read( &ChildID, sizeof( int ) ) )
			return -1;

		// pid֤
		return ChildID;
	}

	// ҥץ¦ν

	// ¹ץ
	r = fork();
	if ( r < 0 ) _exit( 1 );

	if ( r > 0 ) {
		// ҥץ¦ν

		// ϻѤʤ
		FreeArgVec( vArg );
		vArg = NULL;

		// ƥץˡ¹ץpid֤
		if ( !FD_Write.Write( &r, sizeof( int ) ) )
			_exit( 1 );

		// λơȤ0֤
		_exit( 0 );

		return -1;	// ˤãʤ
	}

	// ¹ץ¦ν

	// ѥפĤ
	FD_Read.Close();
	FD_Write.Close();

	// exec
	Exec( cmd, vArg );
	return -1;	// ˤãʤ
}

// ץươλԤ碌
// ץνλơ֤
// Ԥ-1֤
int CProcStart::StartWait() const
{
	char **vArg;
	int r;

	assert( NULL != this );

	// Ѱդ
	vArg = CreateArgVec();
	if ( NULL == vArg ) return -1;

	// Ϥ򺹤ؤ
	if ( !SwapIOPort() ) {
		FreeArgVec( vArg );
		vArg = NULL;
		return -1;
	}

	r = fork();
	if ( r < 0 ) {
		FreeArgVec( vArg );
		vArg = NULL;
		return -1;
	}

	if ( r > 0 ) {
		int status;
		// ƥץϡҥץνλԤ碌

		// 
		FreeArgVec( vArg );
		vArg = NULL;

		// Ϥ򸵤᤹ʼԤƤˤϰʤ
		SwapIOPort();

		// Ԥ碌
		waitpid( r, &status, 0 );
		if ( !WIFEXITED( status ) )
			return -1;

		// λơ֤
		// 255֤줿ϡexec˼ԤΤȸʤơ-1֤Ƥ
		if ( WEXITSTATUS( status ) != 255 )
			return WEXITSTATUS( status );
		else
			return -1;
	}

	// exec
	Exec( cmd, vArg );
	return -1;	// ˤãʤ
}

// ץươ郎ΩޤԤ碌
// ҥץνλơ֤Ԥ-1֤
// (*pFlg)δ֡ʿˤʤޤǡԤ碌롣
// (*pFlg)ˤʤԤ碌λˤϡ(*pid)˥ץIDꤹ롣
int CProcStart::StartWaitCondition( volatile const bool *pFlg, int *pid ) const
{
	char **vArg;
	int r;
	volatile const bool wflg = false;	// 

	assert( NULL != this );

	if ( !pFlg ) pFlg = &wflg;
	if ( pid ) (*pid) = -1;

	// Ѱդ
	vArg = CreateArgVec();
	if ( NULL == vArg ) return -1;

	// Ϥ򺹤ؤ
	if ( !SwapIOPort() ) {
		FreeArgVec( vArg );
		vArg = NULL;
		return -1;
	}

	r = fork();
	if ( r < 0 ) {
		FreeArgVec( vArg );
		vArg = NULL;
		return -1;
	}

	if ( r > 0 ) {
		int status;
		struct timespec req;

		// 
		FreeArgVec( vArg );
		vArg = NULL;

		// Ϥ򸵤᤹ʼԤƤˤϰʤ
		SwapIOPort();

		// 100msñ̤ǴƻԤ
		req.tv_sec = 0;
		req.tv_nsec = 100 * 1000 * 1000;

		// Ԥ碌
		while ( !(*pFlg) && waitpid( r, &status, WNOHANG ) == 0 ) {
			// ֤Ԥ
			if( nanosleep( &req, NULL ) )
				return -1;
		}

		if ( (*pFlg) ) {
			// ޤ줿
			if ( pid ) (*pid) = r;
			return -1;
		}

		if ( !WIFEXITED( status ) )
			return -1;

		// λơ֤
		// 255֤줿ϡexec˼ԤΤȸʤơ-1֤Ƥ
		if ( WEXITSTATUS( status ) != 255 )
			return WEXITSTATUS( status );
		else
			return -1;
	}

	// exec
	Exec( cmd, vArg );
	return -1;
}

// 
char** CProcStart::CreateArgVec() const
{
	list< string >::const_iterator itr;
	char **vArg;
	int i;

	assert( NULL != this );

	// ʸʤΥɥ쥹ˤݻۤ
	vArg = (char**)calloc( sizeof( char* ), listArg.size() + 1 );

	// θġʸۤ
	itr = listArg.begin();
	for ( i = 0; i < listArg.size(); i++ ) {
		// ʸΥΰ
		vArg[i] = (char*)calloc( sizeof( char ), ( itr->length() + 2 ) );
		// Ԥ顢ޤǳݤΰơNULL֤
		if ( !vArg[i] ) {
			FreeArgVec( vArg );
			vArg = NULL;
			return NULL;
		}
		strncpy( vArg[i], itr->c_str(), itr->length() + 1 );
		itr++;
	}
	return vArg;
}

// ˴
void CProcStart::FreeArgVec( char** p ) const
{
	char **wp;

	assert( NULL != this );

	// NULLꤵ줿ϲ⤷ʤ
	if ( NULL == p ) return ;

	// ġʸ˴
	wp = p;
	while ( (*wp) ) {
		free( (*wp) );
		(*wp) = NULL;
		wp++;
	}

	// ʸΥɥ쥹ݻ
	free( p );
}

// exec
void CProcStart::Exec( const string &rCmd, char** pArg ) const
{
	// ҥץexec롣
	execv( rCmd.c_str(), pArg );

	// ԤϤɤ褦ʤΤǡɸ२顼Ϥ˥åФƤ
	fprintf( stderr, "It Failed to exec. command = \"%s\".", rCmd.c_str() );

	_exit( -1 );
}

// ץεưˡꤵ줿FILE*ΥݡȤؤ
bool CProcStart::SwapIOPort() const
{
	list< pair< FILE*, FILE* > >::const_iterator itr, itr2;

	// ꥹȤ˻ꤵ줿FILE*ΥݡȤؤ
	itr = listAssignFile.begin();
	for (; itr != listAssignFile.end(); itr++ ) {
		if ( !GlbFunc::SwapPort( itr->first, itr->second ) )
			break;
	}
	if ( itr == listAssignFile.end() ) return true;

	// ǼԤϡ᤹Ϥ򤹤
	itr2 = listAssignFile.begin();
	for (; itr2 != itr; itr2++ )
		GlbFunc::SwapPort( itr2->first, itr2->second );
	return false;
}

