////////////////////////////////////////////////////////////////////////////
// CThread 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <assert.h>
#include <pthread.h>
#include "Thread.h"

// åѤδؿΥץȥ
extern "C" void* CThread_ThreadEntry( void* );

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CThread::CThread() :
	IsExit( true )
{

}

CThread::~CThread()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// åɤγ
bool CThread::start()
{
	pthread_attr_t att;
	bool r = false;
	assert( IsExit );

	if ( pthread_attr_init( &att ) != 0 )
		return false;

	// Ԥ碌ѤΥե饰ȥޥե
	if ( !TermLock.Initialize() ) return false;
	if ( !ExitFlgLock.Initialize() ) return false;
	TermLock.Lock();

	// λե饰ꤹ
	// ʽλե饰ϡåɤۤ˵ꤹɬפ
	IsExit = false;

	// åɤۤ
	if ( pthread_attr_setdetachstate( &att, PTHREAD_CREATE_DETACHED ) != 0 )
		goto ERR_EXIT;
	if ( pthread_create( &m_ThreadID, &att, CThread_ThreadEntry, this ) != 0 )
		goto ERR_EXIT;

	r = true;

ERR_EXIT:
	if ( !r ) {
		IsExit = true;
		TermLock.Unlock();
	}

	pthread_attr_destroy( &att );
	return r;
}

// åɤΥȥݥ
void CThread::run()
{
	
}

// åɤν
void CThread::RunEntry()
{
	// åɤν򳫻ϤƤ
	this->run();

	// λ
	ExitThread();
}

// åֹ
pthread_t CThread::GetThreadID() const
{
	return m_ThreadID;
}

// ΥåɤνλԤ碌
void CThread::Wait()
{
	bool flg;

	// λե饰ͤ
	ExitFlgLock.Lock();
	flg = IsExit;
	ExitFlgLock.Unlock();

	// Ǥ˽λƤäˤ뤳ȤϤʤ
	if ( flg ) return ;

	// ΥåɤνλԤ碌
	TermLock.Lock();
	TermLock.Unlock();
}

// åɤλ
void CThread::ExitThread()
{
	// λե饰ͤꤹ
	ExitFlgLock.Lock();
	IsExit = true;
	ExitFlgLock.Unlock();

	// Ԥ碌ѥޥե
	TermLock.Unlock();

	// åɤλ
	pthread_exit( NULL );
}

// ֤åɤνλԤ碌
bool CThread::WaitForTime( int ms )
{
	bool flg;
	bool r;

	// λե饰ͤ
	ExitFlgLock.Lock();
	flg = IsExit;
	ExitFlgLock.Unlock();

	// Ǥ˽λƤäˤ뤳ȤϤʤ
	if ( flg ) return true;

	// λԤ碌
	r = TermLock.WaitForTime( ms );
	if ( r ) TermLock.Unlock();	// WaitForTimeͭޥե

	return r;
}

////////////////////////////////////////////////////////////////////////////
// ¾
////////////////////////////////////////////////////////////////////////////

// å
void* CThread_ThreadEntry( void *pArg )
{
	CThread *p = reinterpret_cast< CThread* >( pArg );
	p->RunEntry();
	return NULL;
}

