////////////////////////////////////////////////////////////////////////////
// DrewLineCash.h
// CDrewLineCash饹Υץơ
// CTaEditDraw饹ˤơ褷Ԥݻ롣
// 褹ݡ褹ɬפΤʤΤȽǤ˻Ѥ롣
////////////////////////////////////////////////////////////////////////////

#if !defined( DREWLINECASH_H_INCLUDED_ )
#define DREWLINECASH_H_INCLUDED_

#include "TimeSpec.h"
#include "LineData.h"

class CDrewLineCash
{
public:
	CDrewLineCash( const void *argline, const CTimeSpec &rTime ) :
		pline( argline ), time( rTime ){};

	CDrewLineCash( const CDrewLineCash& r ) :
		pline ( r.pline ), time( r.time ){};

	CDrewLineCash() : pline( NULL ), time(){};

	CDrewLineCash( const CLineData &r ) :
		pline( &r ), time( r.GetModifiedTime() ){};

	const CDrewLineCash& operator =( const CDrewLineCash& r ) {
		pline = r.pline;
		time = r.time;
		return (*this);
	};

	bool operator ==( const CDrewLineCash &r ) const
	{
		return ( pline == r.pline && time == r.time );
	};

protected:
	const void* pline;
	CTimeSpec time;
};

#endif // DREWLINECASH_H_INCLUDED_
