////////////////////////////////////////////////////////////////////////////
// CFileWriter 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEdit_std.h"

#include "FileWriter.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CFileWriter::CFileWriter() :
	pData( NULL ),
	EnableExitFlg( false ),
	InterruptFlg( false ),
	ErrorInfo(),
	CProcesingObj(),
	FaultWithTmp( false )
{

}

CFileWriter::~CFileWriter()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
void CFileWriter::SetInfo( const string &argFN, const CEncodeInfo &argE, const T_LineData *argD, bool flg )
{
	FileName = argFN;
	EncodeInfo = argE;
	pData = argD;
	EnableExitFlg = false;
	InterruptFlg = false;
	UseTmpFile = flg;
	FaultWithTmp = false;
}

// 񤭹ѥåɤΥȥݥ
void CFileWriter::run()
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	string TmpfileName;
	FILE *outfile;
	string InputEncode;
	string OutputEncode;

	EnableExitFlg = false;
	InterruptFlg = false;
	ErrorInfo = true;
	FaultWithTmp = false;

	InputEncode = nl_langinfo( CODESET );
	OutputEncode = EncodeInfo.GetEncodeName();

	// ƥݥΥե򤹤
	if ( UseTmpFile ) {
		if ( !MoveToTmp( FileName, &TmpfileName ) ) {
			// ʤΥåϷɻȤʤ餷
			ErrorInfo = CErrorBool( pConf->RefFaultToSaveTmpFileMsg() );
			FaultWithTmp = true;
			return ;
		}
		if ( InterruptFlg ) return ;
	}

	// եϤ
	outfile = WriteFile( true );

	// 󥳡ɤѴԤ
	if ( outfile ) {
		if ( fseek( outfile, 0, SEEK_SET ) )
			ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		else
			TranseFile( outfile );
		fclose( outfile );
	}

	// ƥݥΥե˴
	// ʥ󥳡ѴԤϡѴ˰öե˽Ϥ뤿ᡢ
	// ϤѴǼԤȤƤ⡢ºݤΥե˲ʤ
	// ΤᡢԤˤƥݥե˴Ԥ
	if ( UseTmpFile ) {
		if ( !InterruptFlg && ErrorInfo )
			unlink( TmpfileName.c_str() );
	}

	EnableExitFlg = true;
}

// λǽݤ
bool CFileWriter::EnableExit() const
{
	return EnableExitFlg;
}

// 
void CFileWriter::Interrupt()
{
	InterruptFlg = true;
}

// 顼
CErrorBool CFileWriter::GetErrorInfo() const
{
	return ErrorInfo;
}

// ƥݥΥեذư
bool CFileWriter::MoveToTmp( const string &argFileName, string *pDestName ) const
{
	VPtr< char > pFNameBuf;
	VPtr< char > pMoveBuf;
	string wS2;
	int outfd = -1;
	FILE *infile = NULL;
	FILE *outfile = NULL;
	int readlen;
	bool r = false;
	int i;

	// ȥǥ쥯ȥƥݥե̾
	wS2 = FileName;
	for ( i = 0; i < wS2.length(); i++ ) {
		if ( wS2[i] == '/' )
			wS2.replace( i, 1, "_", 1 );
	}
	wS2 = string( "/tmp/" ) + wS2 + "_XXXXXX";

	// ե̾ѤΥХåեѰդ
	if ( !pFNameBuf.Malloc( sizeof( char ) * ( wS2.length() + 1 ) ) ) return false;
	strncpy( pFNameBuf.GetPtr(), wS2.c_str(), wS2.length() );
	pFNameBuf.GetPtr()[ wS2.length() ] = '\0';

	// ƥݥΥե򳫤
	outfd = mkstemp( pFNameBuf.GetPtr() );
	if ( -1 == outfd ) return false;
	outfile = fdopen( outfd, "wb" );
	if ( NULL == outfile ) goto ERR_EXIT;
	outfd = -1;

	// Ѥե֤̾
	(*pDestName) = pFNameBuf.GetPtr();
	pFNameBuf.Free();

	// ¸Υե򳫤
	infile = fopen( argFileName.c_str(), "rb" );
	if ( NULL == infile ) goto ERR_EXIT;

	// ȤΰưѤΥХåե
	if ( !pMoveBuf.Malloc( 65536 ) )
		goto ERR_EXIT;

	// ư
	while ( !ferror( infile ) && !feof( infile ) && !ferror( outfile ) && !feof( outfile ) && !InterruptFlg ) {
		readlen = fread( pMoveBuf.GetPtr(), sizeof( char ) , 65536, infile );
		if ( fwrite( pMoveBuf.GetPtr(), sizeof( char ) , readlen, outfile ) < readlen ) goto ERR_EXIT;
	}
	r = !ferror( infile ) && !ferror( outfile );

ERR_EXIT:
	// եĤ
	if ( infile ) fclose( infile );
	infile = NULL;
	if ( outfile ) fclose( outfile );
	outfile = NULL;
	if ( outfd >= 0 ) close( outfd );
	outfd = -1;

	return r;
}

// ƥݥեؤ¸ǼԤΤݤ
bool CFileWriter::GetFaultWithTmpFlg() const
{
	return FaultWithTmp;
}

// եϤ
FILE* CFileWriter::WriteFile( bool NeedToTranseEncode )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	T_LineDataItr_c itr;
	T_LineDataItr_c itrLastLine;	// ǸιԤݥ
	FILE *outfile;

	if ( !NeedToTranseEncode ) {
		// Υեľܳ
		outfile = fopen( FileName.c_str(), "w" );
	}
	else {
		// եƳ
		outfile = tmpfile();
	}
	if ( NULL == outfile ) {
		ErrorInfo = CErrorBool( pConf->RefFaultFileOpenMsg() );
		return NULL;
	}

	// ǸιԤݥȤ륤ƥ졼
	itrLastLine = pData->end();
	--itrLastLine;

	for ( itr = pData->begin(); itr != pData->end() && !ferror( outfile ) && !InterruptFlg; ++itr ) {
		// ԤĽϤ
		fputws( itr->getString().c_str(), outfile );
		// ʺǸιԤˤϲԥɤϤʤ
		if ( itr != itrLastLine ) putwc( L'\n', outfile );
	}

	if ( ferror( outfile ) )
		ErrorInfo = pConf->RefIOErrorMsg( errno );

	if ( !NeedToTranseEncode ) {
		fclose( outfile );
		outfile = NULL;
	}

	return outfile;
}

// ϤեΥ󥳡ɤѴ
bool CFileWriter::TranseFile( FILE *infile )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	char *pConvPath;
	string cmd;
	CProcStart procStart;
	int r, pid;

	// ѴץΥѥ
	pConvPath = getenv( SCEV_CONVERTER_PATH );
	if ( NULL == pConvPath ) {
		ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		return false;
	}

	// ѴѤΥޥɤ
	if ( !procStart.SpecifyCommand( pConvPath ) ) {
		ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		return false;
	}
	procStart.AddArg( "-ifc" );
	procStart.AddArg( nl_langinfo( CODESET ) );
	procStart.AddArg( "-ofc" );
	procStart.AddArg( EncodeInfo.GetEncodeName() );
	procStart.AddArg( "-ofn" );
	procStart.AddArg( FileName );
	procStart.AddArg( "-c" );
	procStart.AddArg( EncodeInfo.GetCRTypeName() );
	procStart.AddArg( "-t" );

	// ޤǤǳߤƤʤݤǧ
	if ( InterruptFlg ) return false;

	// ϸեȡɸϤؤ
	if ( !GlbFunc::SwapPort( stdin, infile ) ) {
		ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		return false;
	}

	// Ѵ¹
	r = procStart.StartWaitCondition( &InterruptFlg, &pid );

	// Ǥ줿ϡѴѥץ򻦤
	if ( InterruptFlg && pid > 0 ) {
		// Ǥ줿ϡpid˻ҥץIDꤵ
		int s;
		kill( pid, SIGKILL );
		waitpid( pid, &s, 0 );
	}

	// ϸեȡɸϤؤ
	if ( !GlbFunc::SwapPort( stdin, infile ) ) {
		ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		fclose( stdin );
		return false;
	}

	// ޥɤμ¹Է̤Ƚ
	if ( r < 0 ) {
		if ( pid > 0 )	// Ǥ줿r<0Ȥʤ
			ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		return false;
	}
	if ( r != 0 ) {
		switch ( r ) {
		case 2:
			ErrorInfo = CErrorBool( pConf->RefEncodeNameIsInvalidMsg() );
			break;
		default:
			ErrorInfo = CErrorBool( pConf->RefFailedToConvertEncodeMsg() );
			break;
		}
		return false;
	}

	return true;
}
