////////////////////////////////////////////////////////////////////////////
// CFindText 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEdit_std.h"
#include "FindText.h"
#include "TextMatchLib.h"
#include "TaEditShell.h"
#include "CompoundStr.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CFindText::CFindText() :
	pDoc( NULL ),
	EnableExitFlg( false ),
	IsMatchedFlg( false ),
	ErrorInfo(),
	IgnoreCase( false ),
	CProcesingObj()
{

}

CFindText::~CFindText()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// Τξꤹ
bool CFindText::SetFindInfo(
	const CTaEditDoc *pArgDoc,
	T_CurPos argSPos,
	const wstring &rArgPtn,
	VClsPtr< CConfigInfo > pArgConf,
	bool argIgnoreCase )
{
	pDoc = pArgDoc;
	SPos = argSPos;
	IsMatchedFlg = false;
	IgnoreCase = argIgnoreCase;

	// ѥ֥Ȥ
	if ( IgnoreCase ) {
		if ( CreateFindObj( &m_IgnoreObj, rArgPtn, pArgConf ) )
			return true;
	}
	else {
		if ( CreateFindObj( &m_SensitiveObj, rArgPtn, pArgConf ) )
			return true;
	}

	pDoc = NULL;
	return false;
}

// 򳫻Ϥ
bool CFindText::start()
{
	assert( NULL != this && NULL != pDoc );
	return CProcesingObj::start();	// åɤ򳫻
}

// ѥå
void CFindText::run()
{
	assert( NULL != this && NULL != pDoc );
	EnableExitFlg = false;

	// 
	if ( IgnoreCase )
		IsMatchedFlg = FindNext( &m_IgnoreObj, &m_ResultRange );
	else
		IsMatchedFlg = FindNext( &m_SensitiveObj, &m_ResultRange );

	// λǽΥե饰
	EnableExitFlg = true;
}

// λǽݤ
bool CFindText::EnableExit() const
{
	return EnableExitFlg;
}

// 
void CFindText::Interrupt()
{
	if ( IgnoreCase )
		m_IgnoreObj.Interrupt();
	else
		m_SensitiveObj.Interrupt();
}

// åɤνλ碌
void CFindText::WaitThreadTerminate()
{
	CThread::Wait();
}

// ֤åɤνλԤ碌
bool CFindText::WaitThreadTerminateForTime( int ms )
{
	return CThread::WaitForTime( ms );
}

// Ĥäݤ
bool CFindText::IsMatched() const
{
	return IsMatchedFlg;
}

// ̤ϰϤ
const T_SelRange& CFindText::GetMatchRange() const
{
	return m_ResultRange;
}

// 顼
CErrorBool CFindText::GetErrorInfo() const
{
	return ErrorInfo;
}

// ѥ֥Ȥι
template< typename T >
bool CFindText::CreateFindObj( T *pFindObj, const wstring &rPattern, VClsPtr< CConfigInfo > pConf ) const
{
	// ֥Ȥ
	if ( pFindObj->Initialize( rPattern.c_str() ) )
			return true;

	// ꤵ줿ѥʸˡ顼ͭ롣

	// 顼åȥ顼ȯ֤
	const wstring &rMsg = GetRegexErrString( pFindObj->GetLastError(), pConf );
	int idx = pFindObj->GetErrorPos() - rPattern.c_str();

	// ɽå
	CCompoundStr wCS;
	if ( !pConf->GetWrongRegexPatternMsg( &wCS, rMsg, idx ) )
		return false;

	// åɽ
	m_TaEditShell->ShowErrorMsgBox( wCS );
	return false;
}

// SRegexΥ顼ͤбå
const wstring& CFindText::GetRegexErrString( N_SRegex::SREGEX_ERR err, VClsPtr< CConfigInfo > pConf ) const
{
	switch ( err ) {
	case N_SRegex::SRE_EOF_NOT_ANTICIPATED:
		return pConf->RefWRP_EofNotAnticipated();

	case N_SRegex::SRE_OUT_OF_MEMORY:
		return pConf->RefWRP_OutOfMemory();

	case N_SRegex::SRE_UNCERTAIN_CHAR:
		return pConf->RefWRP_UncertainChar();

	case N_SRegex::SRE_ZERO_LENGTH_PTN:
		return pConf->RefWRP_ZeroLengthPattern();

	case N_SRegex::SRE_UNEXPENTED:
	default:
		return pConf->RefWRP_Unexpected();
	}
}

// 
template< typename T >
bool CFindText::FindNext( T *pFindObj, T_SelRange *pRange ) const
{
	tagPseudPtr MatchSPos, MatchEPos;	// ޥåϰϤݻ
	T_LineDataItr_c wItr;
	T_CurPos wSPos, wEPos;
	bool r;

	// Ѥεݥ󥿤
	tagPseudPtr pseudPtr( &( pDoc->RefData() ), pDoc->RefData().begin() + SPos.GetLine(), SPos );

	// 
	r = pFindObj->FindMatchStr( pseudPtr, &MatchSPos, &MatchEPos );
	if ( !r ) return false;

	wSPos = MatchSPos.GetCurPos();
	wEPos = MatchEPos.GetCurPos();

	// ϰֵڤӽλ֤Ǹι+1ˤʤäϡǸιԤʸꤹ
	wItr = pDoc->RefData().end();
	--wItr;
	if ( wSPos.GetLine() == pDoc->RefData().size() )
		wSPos = T_CurPos( pDoc->RefData().size() - 1, wItr->length() );
	if ( wEPos.GetLine() == pDoc->RefData().size() )
		wEPos = T_CurPos( pDoc->RefData().size() - 1, wItr->length() );

	// ̤֤
	(*pRange) = T_SelRange( wSPos, wEPos );
	return true;
}

